#!/usr/local/bin/perl
#
# name
#    3dee_transform_script.pl
# purpose
#    runs program 3dee_transform on transformation coordinates
#    fires up rasmol and a tk/tcl window to allow selection of domains
# author
#    Copyright (C)  Asim Siddiqui August 1996
#    Lab of Molecular Biophysics, Oxford UK
#    All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation
#
# contains a modified version of rmscop written by Tim Hubbard
# Centre for Protein Engineering, MRC Centre, Cambridge, UK
# also distributed under the GNU General Public License
#
# version
#    1.1
#
# The following variables should be configured for the local system
#
# 1)
# location of 3dee_transform program
$dee3_transform_pos = "/home/snail/as/perl/transforms/tk-tcl/";
#
# 2)
# location of directory for temporary files
$temp_dir = "/tmp";
#
# 3)
# location of wish command (comes with tk-tcl package - if you use the
# default installation the following variable should not need changing)
$wish_command = "/usr/local/bin/wish";
#
# 4)
# location of pdb files
$pdb_dir = "/hailey/data/pdb/";
#
# 5)
# do you want progress messages (0 for standard messages)
#                               (1 for no messages at all)
#                               (2 for all output)
$message_reports = 0;

require 'getopts.pl';
require 'flush.pl';

&Getopts('f:');

if ($opt_f eq "") {
    print stderr "Must provide a transformation file\n";
    exit;
}

$in_file = $opt_f;



&setup_text_widget;


@colours = ("red", "green", "blue", "yellow", "purple", "cyan", "magenta",
            "white", "greenblue", "violet", "redorange");

$output_file = &get_temp_file();
$transform_file = &get_temp_file();
#$wish_file = &get_temp_file();

# read in input file
open(INPUT, "$in_file");
@lines = <INPUT>;
close INPUT;

# produce transformation file
open(TRANSFORM_FILE, ">$transform_file");
$i = 0;
$j = 0;
$to_print = 0;
while ($i <= $#lines) {
    $_ = $lines[$i];
    if (/\{/) {
        ($pdb_file, $domain_name, $rest) = split(" ", $_, 3);
# if file exists print out transformation else warn user and ignore
        if (-e "$pdb_dir/pdb$pdb_file.ent") {
            $to_print = 1;
            print TRANSFORM_FILE "$pdb_dir/pdb$pdb_file.ent $domain_name $rest";
            ($code, $d_num, $identifier) = split("-", $domain_name, 3);
            $domain_names[$j] = "$code-$d_num";
            $j++;
        } else {
            $to_print = 0; 
            &pr_to_text_widget("WARNING!! No such file $pdb_dir/pdb$pdb_file.ent IGNORED");
        }
    } elsif ($to_print == 1) {
        print TRANSFORM_FILE $_;
    }
    $i++;
} 
close TRANSFORM_FILE;

&pr_to_text_widget("Running Transform");
open(PROG, "$dee3_transform_pos/3dee_transform -o $output_file -f $transform_file -m |");
while (<PROG>) {
    chop;
    if ($message_reports == 2) {
        &pr_to_text_widget("$_");
    } else {
        &pr_to_text_w_no_nline(".");
    }
}
close PROG;

#open(WISH_CL, ">$wish_file");
open(WISH_CL, "|$wish_command -f $wish_file");

&print_wish_cl_header;

&print_buttons;

close WISH_CL;

#system("$wish_command -f $wish_file");

# now remove pdb file, wish file and transformation file

unlink $output_file, $transform_file;

sub get_temp_file {
    local($i,$tempfile);

    $tempfile = $temp_dir . "/3dee.transform.tmp.";
    $i = 0;

    while(-e "$tempfile$i") {
        if (-M "$tempfile$i" > 0.1 && -o "$tempfile$i") {
            unlink("$tempfile$i");
        } else {
            $i++;
        }
    }

    open(TEMP, ">$tempfile$i");
    close TEMP;

    return("$tempfile$i")
}

sub print_wish_cl_header {

print WISH_CL <<"EOF";
#
# installation:
# save this file as rmscop to a directory in your path
# edit points marked 'local-config' if required
#
# \$Header: /nfs/offa/beo/local/www/dev/docs/std/rs/RCS/rmscop.txt,v 1.3 1996/07/20 11:31:11 th Exp \$
#
# Copyright (C) 1994-6 Tim Hubbard
# Centre for Protein Engineering, MRC Centre, Cambridge, UK
# All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation
#
# 17/8/95 - beta version
# 1/10/95 - added ability to read/display PDB file directly
# 30/4/96 - added ftp to /usr/tmp ability
# 20/7/96 - fixed to work under tk4.0
#
# Function:
#
# tcl/tk script to direct rasmol commands from scop to 
# existing rasmol windows
#
# Usage:
#
# rmscop
#
#   starts xterm, rasmol windows
#
# rmscop coordinatefilename
#
#   displays coordinatefilename in existing rasmol window or starts
#   rasmol if none running
#
# rmscop rasmolscriptfile
#
#   loads coordinatefile specified by 'load' in rasmolscriptfile
#   into existing rasmol window or starts rasmol if none running
#
# Known bugs:
#
# Will only deal with N rasmols, according to the number of duplicated
# commands in this script - generation of buttons is not in a loop
# since there seems no way to memorize
# the different exit commands without defining each explicitly
#

# if there is no argument, assume this was a command from the user
# interpret it as an instruction to start rasmol

# global variables:

# local config: things you may need to change:

# 1. location of pdb files on your system

# use this line if RASMOLPDBPATH defined elsewhere
set pdbdir {/hailey/data/pdb/}
# use this line if RASMOLPDBPATH undefined
#set pdbdir {/pdb_disk/pdb_directory/}

# 2. name of rasmol in your path (2.6 supported by rsgen.cgi)
set rasmol {rasmol}

# check if any arguments.  If not, start rasmol.

#if { \$argc != 1 } {
#  wm geometry . 250x0+10+10
#  wm title . "Starting Rasmol.."
#  exec xterm -geometry 80x10+10-10 -font 6x10 -e \$rasmol &
#  exit
#}

# check argv points to real file.  If not, stop with error.

#if {!([file exists [lindex \$argv 0]])} {
#  puts stdout "Arguments must be files of valid rasmol commands"
#  exit
#}

# check for rsgen.cgi output

#  set f [open [lindex \$argv 0] r]
  set coml {[zap}
#  while {[gets \$f line] >=0} {
# replace with file we are going to actually load
#    regsub {load pdb[0-9][a-z]+\\.ent} \$line "load \${pdbfile}" t1
#    set line \$t1
#    lappend coml \$line
#  }
  lappend coml {load nmrpdb $output_file}
  lappend coml {wireframe off}
  lappend coml ]
#  close \$f
  set com [join \$coml @]
  regsub -all {@@} \$com {@} com1
  regsub -all {@\\]} \$com1 {]} com2
  regsub -all {@} \$com2 {][} com
# looking for the segment
# cpk on][select not 'region'][backbone 80 
# to turn this off
#  regsub {(cpk on\\]\\[select not)(.*)(\\]\\[backbone) 80(\\]\\[select) all} \$com {\\1\\2\\3 off\\4\\2} com1


# commands are in \$com and \$com1

# now work out where to send them:

# find out if there are any rasmol's running

set x 0
set coml {}
foreach i [winfo interps] {
  if {[string match rasmol* \$i] && ([string length \$i] < 11)} {
    incr x +1
    set rasapp \$i
    lappend coml \$i
  }
}

# more than one rasmol running, must choose between them...

if { \$x > 1} {
  wm geometry . +10+10
  button .quit -text "Quit" -command {destroy .}
  pack .quit -side bottom -fill x
  if {\$com != \$com1} {
    frame .left 
    pack .left -side left
    frame .right
    pack .right -side right
  } else {
    frame .left
    pack .left -side top -fill x
  }
# 1
  set y 0
  set yy 10
  set rmc1 [lindex \$coml \$y]
  incr y +1
  button .\$y -text "->rasmol \$y (all)" -command {
    send \$rmc1 \$com
    destroy .
  }
  pack .\$y -in .left -fill x
  if {\$com != \$com1} {
    button .\$yy -text "(region only)" -command {
      send \$rmc1 \$com1
      destroy .
    }
    pack .\$yy -in .right
  }
# 2
  set rmc2 [lindex \$coml \$y]
  incr y +1
  button .\$y -text "->rasmol \$y (all)" -command {
    send \$rmc2 \$com
    destroy .
  }
  pack .\$y -in .left -fill x
  incr yy +1
  if {\$com != \$com1} {
    button .\$yy -text "(region only)" -command {
      send \$rmc2 \$com1
      destroy .
    }
    pack .\$yy -in .right
  }
  if {\$x > \$y} {
    set rmc3 [lindex \$coml \$y]
    incr y +1
    button .\$y -text "->rasmol \$y (all)" -command {
      send \$rmc3 \$com
      destroy .
    }
    pack .\$y -in .left -fill x
    incr yy +1
    if {\$com != \$com1} {
      button .\$yy -text "(region only)" -command {
        send \$rmc3 \$com1
        destroy .
      }
      pack .\$yy -in .right
    }
  }
  if {\$x > \$y} {
    set rmc4 [lindex \$coml \$y]
    incr y +1
    button .\$y -text "->rasmol \$y (all)" -command {
      send \$rmc4 \$com
      destroy .
    }
    pack .\$y -in .left -fill x
    incr yy +1
    if {\$com != \$com1} {
      button .\$yy -text "(region only)" -command {
        send \$rmc4 \$com1
        destroy .
      }
      pack .\$yy -in .right
    }
  }

} else {

# if rasmol not running, need to start it up
  if { \$x == 0 } {
    wm geometry . 250x0+10+10
    wm title . "Starting Rasmol.."
    exec xterm -geometry 80x10+10-10 -font 6x10 -e \$rasmol &

# wait for rasmol to start running
    while { \$x == 0 } {
      foreach i [winfo interps] {
        if {[string match rasmol* \$i] && ([string length \$i] < 11)} {
          set x 1
          set rasapp \$i
          break
        }
      }
      set y 0
      while { \$y < 1000 } {
        incr y +1
      }
    }
  }


# send required commands to rasmol

  wm geometry . 250x0+10+10
  wm title . "Sending to Rasmol.."

  send \$rasapp \$com

}

# procedure for switching model on and off
proc ShowModel { varname model rasapp } {
    upvar #0 \$varname var

    if {\$var == 0} {
        send \$rasapp "select ::\$model"
        send \$rasapp {backbone off}
        send \$rasapp {wireframe off}
    } else {
        send \$rasapp "select ::\$model"
        send \$rasapp {wireframe off}
        send \$rasapp {backbone 30}
    }
}
EOF

}

sub print_buttons {

    print WISH_CL "wm title . \"Select models\"\n";
    print WISH_CL "wm minsize . 100 " . 50 * ($#domain_names + 1) . "\n";
    print WISH_CL "button .quit -text \"Quit\" -command {destroy .}\n";
    $#items = -1;

    $i = 0;
    while ($i <= $#domain_names) {
        $model_num = $i + 1;
        $colour = $colours[$i % ($#colours + 1)];
        print WISH_CL "send \$rasapp \"select ::$model_num\"\n";
        print WISH_CL "send \$rasapp \"backbone 30\"\n";
        print WISH_CL "send \$rasapp \"colour $colour\"\n";

        print WISH_CL "set radio$i 1\n";

        print WISH_CL "checkbutton .radio$i -text {$domain_names[$i] $colour} -command [ list ShowModel radio$i $model_num \$rasapp ]\n";
        push(@items, ".radio$i");
        $i++;
    }

    $str = join(" ", @items);
    print WISH_CL "pack $str .quit -side top\n";

}

sub setup_text_widget {
    if ($message_reports == 1) {
        return;
    }
    open(WISH_TEXT, "| $wish_command -f ");
print WISH_TEXT <<"EOF";
wm title . "3Dee tranformation interface messages"
frame .f
pack .f -side top -fill both -expand true
button .quit -text "Close" -command {destroy .}
pack .quit
set t [text .f.t -setgrid true -wrap word -width 42 -height 14 -yscrollcommand ".f.sy set"]
scrollbar .f.sy -orient vert -command ".f.t yview"
pack .f.sy -side right -fill y
pack .f.t -side left -fill both -expand true
EOF

}


sub pr_to_text_widget {

    local($line) = @_;

    print WISH_TEXT "\$t insert end \"$line\\n\"\n";
    &flush(WISH_TEXT);
}

sub pr_to_text_w_no_nline {

    local($line) = @_;

    print WISH_TEXT "\$t insert end \"$line\"\n";
    &flush(WISH_TEXT);
}
