/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.util.annotation.NotThreadSafe;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

@NotThreadSafe
public class MultiAnnotatedSequence<T extends Enum<T>> {
    private EnumMap<T, ArrayList<Float>> annotations;

    MultiAnnotatedSequence() {
    }

    public MultiAnnotatedSequence(Class<T> clazz) {
        this.annotations = new EnumMap(clazz);
    }

    public void addAnnotation(T t, ArrayList<Float> arrayList) {
        assert (t != null) : "Type is expected";
        assert (arrayList != null) : "Not empty value is expected!";
        if (!this.annotations.isEmpty()) assert (this.annotations.values().iterator().next().size() == arrayList.size()) : "Annotations must contain the same number of elements!";
        this.annotations.put(t, arrayList);
    }

    public Map<T, List<Float>> getAnnotations() {
        return new EnumMap<T, ArrayList<Float>>(this.annotations);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.annotations == null ? 0 : this.annotations.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiAnnotatedSequence multiAnnotatedSequence = (MultiAnnotatedSequence)object;
        return !(this.annotations == null ? multiAnnotatedSequence.annotations != null : !this.annotations.equals((Object)multiAnnotatedSequence.annotations));
    }

    public String toString() {
        String string = "";
        for (Map.Entry<T, ArrayList<Float>> entry : this.annotations.entrySet()) {
            string = string + entry.getKey() + " ";
            string = string + entry.getValue() + "\n";
        }
        return string;
    }
}

