/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.ConservationMethod;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Score {
    static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.UK);
    private ConservationMethod method;
    private List<Float> scores;

    private Score() {
    }

    public Score(ConservationMethod conservationMethod, List<Float> list) {
        this.method = conservationMethod;
        this.scores = new ArrayList<Float>(list);
    }

    public ConservationMethod getMethod() {
        return this.method;
    }

    public List<Float> getScores() {
        return this.scores;
    }

    public String toString() {
        return "Score [method=" + (Object)((Object)this.method) + ", scores=" + this.scores + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.method == null ? 0 : this.method.hashCode());
        n = 31 * n + (this.scores == null ? 0 : ((Object)this.scores).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Score score = (Score)object;
        if (this.method != score.method) {
            return false;
        }
        if (this.scores == score.scores) {
            return true;
        }
        if (this.scores == null) {
            return false;
        }
        return Arrays.deepEquals(this.scores.toArray(), score.scores.toArray());
    }

    public static void write(Set<Score> set, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("OutputStream must be provided!");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        for (Score score : set) {
            bufferedWriter.write("#" + (Object)((Object)score.method) + " ");
            for (Float f : score.getScores()) {
                bufferedWriter.write(NUMBER_FORMAT.format(f) + " ");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.flush();
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_FORMAT.setMaximumFractionDigits(3);
    }
}

