/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.data.sequence.FastaSequence;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class LimitExceededException
extends JobSubmissionException {
    private static final long serialVersionUID = 15066952180013505L;
    int numberOfSequencesAllowed;
    int actualNumberofSequences;
    int aSequenceLenghtAllowed;
    int aSequenceLenghtActual;

    public LimitExceededException(String string) {
        super(string);
    }

    public static LimitExceededException newLimitExceeded(Limit<?> limit, List<FastaSequence> list) {
        String string = "Job exceed size limits, maximum number of sequences must be less than " + limit.getSeqNumber() + "\n";
        if (limit.getAvgSeqLength() != 0) {
            string = string + "and an average sequence length must not exceed " + limit.getAvgSeqLength() + "\n";
        }
        string = string + " However, the task contained " + list.size() + " sequences " + "\n";
        if (limit.getAvgSeqLength() != 0) {
            string = string + "and an average sequence length was " + Limit.getAvgSequenceLength(list) + "\n";
        }
        return new LimitExceededException(string);
    }

    public int getNumberOfSequencesAllowed() {
        return this.numberOfSequencesAllowed;
    }

    public int getActualNumberofSequences() {
        return this.actualNumberofSequences;
    }

    public int getSequenceLenghtAllowed() {
        return this.aSequenceLenghtAllowed;
    }

    public int getSequenceLenghtActual() {
        return this.aSequenceLenghtActual;
    }
}

