/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.Annotation;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Score;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.server.AAConWS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class AAConClient {
    private static final Logger log = Logger.getLogger(AAConClient.class.getCanonicalName());
    static final String QUALIFIED_SERVICE_NAME = "http://msa.data.compbio/01/12/2010/";
    static final String hostname = "http://www.compbio.dundee.ac.uk/aacon";
    static final String serviceName = "AAConWS";

    AAConClient(String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Collection<Object> collection;
        File file = IOHelper.getFile(stringArray, "-i", true);
        File file2 = IOHelper.getFile(stringArray, "-o", false);
        File file3 = IOHelper.getFile(stringArray, "-f", true);
        String string = CmdHelper.getPresetName(stringArray);
        Annotation<AAConWS> annotation = AAConClient.connect();
        Preset<AAConWS> preset = null;
        if (string != null) {
            preset = MetadataHelper.getPreset(annotation, string);
        }
        List<Option<AAConWS>> list = null;
        if (file3 != null) {
            collection = IOHelper.loadParameters(file3);
            list = MetadataHelper.processParameters(collection, annotation.getRunnerOptions());
        }
        collection = null;
        if (file != null) {
            System.out.println("Calculating conservation...");
            collection = AAConClient.analize(file, annotation, preset, list);
            OutputStream outputStream = null;
            outputStream = file2 != null ? IOHelper.getOutStream(file2) : System.out;
            AAConClient.writeOut(outputStream, collection);
        }
        if (bl3 = CmdHelper.listParameters(stringArray)) {
            System.out.println(MetadataHelper.getParametersList(annotation));
        }
        if (bl2 = CmdHelper.listPresets(stringArray)) {
            System.out.println(MetadataHelper.getPresetList(annotation));
        }
        if (bl = CmdHelper.listLimits(stringArray)) {
            System.out.println(MetadataHelper.getLimits(annotation));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)annotation)).close();
        log.fine("Disconnected successfully!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(OutputStream outputStream, Set<Score> set) {
        try {
            Score.write(set, outputStream);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Annotation<AAConWS> connect() throws WebServiceException {
        URL uRL = null;
        log.log(Level.FINE, "Attempting to connect...");
        try {
            uRL = new URL("http://www.compbio.dundee.ac.uk/aacon/AAConWS?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        QName qName = new QName(QUALIFIED_SERVICE_NAME, serviceName);
        Service service = Service.create((URL)uRL, (QName)qName);
        QName qName2 = new QName(QUALIFIED_SERVICE_NAME, "AAConWSPort");
        Annotation annotation = (Annotation)service.getPort(qName2, Annotation.class);
        log.log(Level.FINE, "Connected successfully!");
        return annotation;
    }

    static Set<Score> analize(File file, Annotation<AAConWS> annotation, Preset<AAConWS> preset, List<Option<AAConWS>> list) {
        List<FastaSequence> list2 = null;
        HashSet<Score> hashSet = null;
        try {
            list2 = SequenceUtil.openInputStream(file.getAbsolutePath());
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? annotation.customAnalize(list2, list) : (preset != null ? annotation.presetAnalize(list2, preset) : annotation.analize(list2));
            Thread.sleep(1000L);
            hashSet = annotation.getAnnotation(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            System.err.println("Exception while parsing the web method input parameters. Exception details are below:");
            wrongParameterException.printStackTrace();
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            System.err.println("Exception while attempting to read the input file Exception details are below:");
            System.out.println(unknownFileFormatException.getMessage());
            unknownFileFormatException.printStackTrace();
        }
        return hashSet;
    }

    static void printUsage(int n) {
        System.out.println();
        System.out.println("Usage: <Class or Jar file name>  ACTION [OPTIONS] ");
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("-i=<inputFile> - full path to fasta or Clustal formatted alignment file ");
        System.out.println("-parameters - lists parameters supported by web service");
        System.out.println("-presets - lists presets supported by web service");
        System.out.println("-limits - lists web services limits");
        System.out.println("Please note that if input file is specified other actions are ignored");
        System.out.println();
        System.out.println("OPTIONS (only for use with -i action):");
        System.out.println("-r=<presetName> - name of the preset to use");
        System.out.println("-o=<outputFile> - full path to the file where to write the result");
        System.out.println("-f=<parameterInputFile> - the name of the file with the list of parameters to use.");
        System.out.println("Please note that -r and -f options cannot be used together. Conservation is calculated with either a preset or the parameters from the file, but not both!");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            AAConClient.printUsage(1);
        }
        if (stringArray.length < 1) {
            System.out.println("No options is specified! ");
            AAConClient.printUsage(1);
        }
        try {
            new AAConClient(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

