/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IOHelper {
    static File getFile(String[] stringArray, String string, boolean bl) throws IOException {
        assert (string != null && string.trim().length() != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!(string2 = string2.trim()).toLowerCase().startsWith(string + "=")) continue;
            string2 = string2.substring((string + "=").length());
            File file = new File(string2);
            if (bl && !file.exists()) {
                System.out.println(string + " file " + file.getAbsolutePath() + " does not exist");
                return null;
            }
            if (!bl && !file.exists()) {
                file.createNewFile();
            }
            if (!file.canRead()) {
                System.out.println("Cannot read " + string + " file " + file.getAbsolutePath());
                return null;
            }
            return file;
        }
        return null;
    }

    static List<String> loadParameters(File file) throws IOException {
        assert (file != null && file.exists());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    static OutputStream getOutStream(File file) {
        assert (file != null && file.exists());
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeOut(OutputStream outputStream, Alignment alignment) {
        try {
            ClustalAlignmentUtil.writeClustalAlignment(outputStream, alignment);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

