/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.client.Services;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class Jws2Client {
    private static final Logger log = Logger.getLogger(Jws2Client.class.getCanonicalName());
    static final String QUALIFIED_SERVICE_NAME = "http://msa.data.compbio/01/01/2010/";
    static final String V2_QUALIFIED_SERVICE_NAME = "http://msa.data.compbio/01/12/2010/";

    public static boolean validURL(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    <T> Jws2Client(String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        Services services;
        String string;
        String string2 = CmdHelper.getHost(stringArray);
        if (string2 == null) {
            System.out.println("Host name is not provided!");
            Jws2Client.printUsage(1);
        }
        if (!Jws2Client.validURL(string2)) {
            System.out.println("Host name is not valid!");
            Jws2Client.printUsage(1);
        }
        if ((string = CmdHelper.getServiceName(stringArray)) == null) {
            System.out.println("Service name is no provided!");
            Jws2Client.printUsage(1);
        }
        if ((services = Services.getService(string)) == null) {
            System.out.println("Service " + string + " is no supported! Valid values are: " + Arrays.toString((Object[])Services.values()));
            Jws2Client.printUsage(1);
        }
        File file = IOHelper.getFile(stringArray, "-i", true);
        File file2 = IOHelper.getFile(stringArray, "-o", false);
        File file3 = IOHelper.getFile(stringArray, "-f", true);
        String string3 = CmdHelper.getPresetName(stringArray);
        Metadata metadata = (Metadata)((Object)Jws2Client.connect(string2, services));
        Preset preset = null;
        if (string3 != null) {
            preset = MetadataHelper.getPreset(metadata, string3);
        }
        List list = null;
        if (file3 != null) {
            object = IOHelper.loadParameters(file3);
            list = MetadataHelper.processParameters(object, metadata.getRunnerOptions());
        }
        object = null;
        if (file != null) {
            if (services == Services.AAConWS) {
                System.out.println("calc conserv!");
            } else {
                object = Jws2Client.align(file, (MsaWS)metadata, preset, list);
                OutputStream outputStream = null;
                outputStream = file2 != null ? IOHelper.getOutStream(file2) : System.out;
                IOHelper.writeOut(outputStream, (Alignment)object);
            }
        }
        if (bl3 = CmdHelper.listParameters(stringArray)) {
            System.out.println(MetadataHelper.getParametersList(metadata));
        }
        if (bl2 = CmdHelper.listPresets(stringArray)) {
            System.out.println(MetadataHelper.getPresetList(metadata));
        }
        if (bl = CmdHelper.listLimits(stringArray)) {
            System.out.println(MetadataHelper.getLimits(metadata));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)metadata)).close();
        log.fine("Disconnected successfully!");
    }

    public static JABAService connect(String string, Services services) throws WebServiceException {
        Service service;
        block4: {
            URL uRL = null;
            log.log(Level.FINE, "Attempting to connect...");
            try {
                uRL = new URL(string + "/" + services.toString() + "?wsdl");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            service = null;
            try {
                service = services.getService(uRL, QUALIFIED_SERVICE_NAME);
            }
            catch (WebServiceException webServiceException) {
                System.out.println("Conecting to JABAWS version 2 service");
                if (!Jws2Client.isV2service(webServiceException)) break block4;
                service = services.getService(uRL, V2_QUALIFIED_SERVICE_NAME);
            }
        }
        JABAService jABAService = services.getInterface(service);
        log.log(Level.FINE, "Connected successfully!");
        return jABAService;
    }

    static boolean isV2service(WebServiceException webServiceException) {
        String string = webServiceException.getMessage();
        int n = string.indexOf("not a valid service");
        return n > 0 && string.substring(n).contains(V2_QUALIFIED_SERVICE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Alignment align(File file, MsaWS<T> msaWS, Preset<T> preset, List<Option<T>> list) {
        FileInputStream fileInputStream = null;
        List<FastaSequence> list2 = null;
        Alignment alignment = null;
        try {
            fileInputStream = new FileInputStream(file);
            list2 = SequenceUtil.readFasta(fileInputStream);
            fileInputStream.close();
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? msaWS.customAlign(list2, list) : (preset != null ? msaWS.presetAlign(list2, preset) : msaWS.align(list2));
            Thread.sleep(1000L);
            alignment = msaWS.getResult(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            wrongParameterException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return alignment;
    }

    static void printUsage(int n) {
        System.out.println();
        System.out.println("Usage: <Class or Jar file name> -h=host_and_context -s=serviceName ACTION [OPTIONS] ");
        System.out.println();
        System.out.println("-h=<host_and_context> - a full URL to the JWS2 web server including context path e.g. http://10.31.1.159:8080/ws");
        System.out.println("-s=<ServiceName> - one of " + Arrays.toString((Object[])Services.values()));
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("-i=<inputFile> - full path to fasta formatted sequence file, from which to align sequences");
        System.out.println("-parameters - lists parameters supported by web service");
        System.out.println("-presets - lists presets supported by web service");
        System.out.println("-limits - lists web services limits");
        System.out.println("Please note that if input file is specified other actions are ignored");
        System.out.println();
        System.out.println("OPTIONS (only for use with -i action):");
        System.out.println("-r=<presetName> - name of the preset to use");
        System.out.println("-o=<outputFile> - full path to the file where to write an alignment");
        System.out.println("-f=<parameterInputFile> - the name of the file with the list of parameters to use.");
        System.out.println("Please note that -r and -f options cannot be used together. Alignment is done with either preset or a parameters from the file, but not both!");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            Jws2Client.printUsage(1);
        }
        if (stringArray.length < 2) {
            System.out.println("Host and service names are required!");
            Jws2Client.printUsage(1);
        }
        try {
            new Jws2Client(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

