/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.Metadata;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import java.util.ArrayList;
import java.util.List;

public class MetadataHelper {
    static <T> List<Option<T>> getParametersList(Metadata<T> metadata) {
        assert (metadata != null);
        return metadata.getRunnerOptions().getArguments();
    }

    static <T> PresetManager<T> getPresetList(Metadata<T> metadata) {
        assert (metadata != null);
        PresetManager<T> presetManager = metadata.getPresets();
        return presetManager;
    }

    static <T> List<Limit<T>> getLimits(Metadata<T> metadata) {
        assert (metadata != null);
        LimitsManager<T> limitsManager = metadata.getLimits();
        return limitsManager != null ? limitsManager.getLimits() : null;
    }

    static <T> Preset<T> getPreset(Metadata<T> metadata, String string) {
        assert (string != null);
        PresetManager<T> presetManager = MetadataHelper.getPresetList(metadata);
        if (presetManager == null) {
            System.out.println("No presets are supported by the service! Ignoring -r directive!");
            return null;
        }
        Preset<T> preset = presetManager.getPresetByName(string);
        if (preset == null) {
            System.out.println("Cannot find preset: " + string + " WARN: ignoring -r directive!");
        }
        return preset;
    }

    static <T> List<Option<T>> processParameters(List<String> list, RunnerConfig<T> runnerConfig) {
        ArrayList<Option<T>> arrayList = new ArrayList<Option<T>>();
        for (String string : list) {
            String string2 = null;
            string2 = MetadataHelper.isParameter(string) ? MetadataHelper.getParamName(string) : string;
            Option<T> option = runnerConfig.getArgumentByOptionName(string2);
            if (option == null) {
                System.out.println("WARN ignoring unsuppoted parameter: " + string2);
                continue;
            }
            if (MetadataHelper.isParameter(string)) {
                try {
                    option.setValue(MetadataHelper.getParamValue(string));
                }
                catch (WrongParameterException wrongParameterException) {
                    System.out.println("Problem setting value for the parameter: " + string);
                    wrongParameterException.printStackTrace();
                }
            }
            arrayList.add(option);
        }
        return arrayList;
    }

    static String getParamName(String string) {
        assert (MetadataHelper.isParameter(string));
        return string.substring(0, string.indexOf("="));
    }

    static String getParamValue(String string) {
        assert (MetadataHelper.isParameter(string));
        return string.substring(string.indexOf("=") + 1);
    }

    static boolean isParameter(String string) {
        return string.contains("=");
    }
}

