# Makefile for ALSCRIPT, msf2blc and clus2blc programs
#
# 22 June 1993:  Add alsnum program
#
# These programs require an ANSI C compiler
#
# This makefile is for Sun computers running Solaris 2.x
#
CC = cc 
MACHINE = sol
CFLAGS = -O
LFLAGS = -I./ -o
ALOBJS = alscript.o alps.o gjutil.o agetbloc.o ckdd.o gjtimes.o
#
PROGS = alscript msf2blc clus2blc alsnum fast2blc

all: $(PROGS)

alscript: $(ALOBJS)
	$(CC) $(CFLAGS) $(ALOBJS) $(LFLAGS) alscript
msf2blc: msf2blc.o gjutil.o gjtimes.o
	$(CC) $(CFLAGS) msf2blc.o gjutil.o $(LFLAGS) msf2blc
clus2blc: clus2blc.o gjutil.o gjtimes.o
	$(CC) $(CFLAGS) clus2blc.o gjutil.o $(LFLAGS) clus2blc
fast2blc: fast2blc.o gjutil.o  gjtimes.o
	$(CC) $(CFLAGS) fast2blc.o gjutil.o $(LFLAGS) fast2blc
alsnum: alsnum.o gjutil.o agetbloc.o gjtimes.o
	$(CC) $(CFLAGS) alsnum.o gjutil.o agetbloc.o gjtimes.o $(LFLAGS) alsnum

alscript.o: alscript.c array.h gjutil.h version.h
	$(CC) $(CFLAGS) -c alscript.c

alps.o: alps.c array.h gjutil.h version.h
	$(CC) $(CFLAGS) -c alps.c

agetbloc.o: agetbloc.c array.h gjutil.h
	$(CC) $(CFLAGS) -c agetbloc.c

gjutil.o: gjutil.c gjutil.h
	$(CC) $(CFLAGS) -c gjutil.c

clus2blc.o: clus2blc.c array.h gjutil.h defaults.h
	$(CC) $(CFLAGS) -c clus2blc.c

fast2blc.o: fast2blc.c array.h gjutil.h defaults.h
	$(CC) $(CFLAGS) -c fast2blc.c

msf2blc.o: msf2blc.c array.h gjutil.h defaults.h
	$(CC) $(CFLAGS) -c msf2blc.c

ckdd.o: ckdd.c array.h
	$(CC) $(CFLAGS) -c ckdd.c

alsnum.o: alsnum.c array.h gjutil.h defaults.h
	$(CC) $(CFLAGS) -c alsnum.c








