# include "includes.h"

/****************************************************************************//*
    Report for whole alignment...
*//****************************************************************************/

void ncrep(bloc,cl,count,noclust,intcons,consval,point,ptype,resipos,simname)
int **intcons;
int count,consval,noclust,point;
struct resisto *resipos;
struct seqdat *bloc;
struct slist ptype;
struct indclust *cl;
char *simname;


{ 
  FILE *sim;
  int  sto,tally,ngaps,tsp,numbs;
  int  ml,my,mu,mz,qx,qy,qz,posto,msto,rchrlen,none;
  int  *cd;
  char *er,comb;

  cd = (int*)  malloc(sizeof(int)*(ptype.syno+1));
  er = (char*) malloc(sizeof(char)*(ptype.pno+2)); 
  if((sim=fopen(simname,"a"))==NULL){
    printf("Error: cant open file %s\n",simname);
    exit(0);
  } 


  fprintf(sim,"****************\n");
  fprintf(sim,"*1* IDENTITIES *\n");
  fprintf(sim,"****************\n\n");

  fprintf(sim,"* Identity within one sub-group\n\n");

  sto=0;tally=0;
  for(ml=1;ml<count+1;++ml){ 
    if(intcons[1][ml]==point+1){
      if(sto!=ml){
        tally++;
        fprintf(sim,"\n(%3d)",ml);
        sto=ml;
      }else fprintf(sim," ");
      qz=1;
      while((bloc[cl[1].order[qz]].seq[ml]==' ')&&
            (qz<cl[1].number+1))qz++;

      fprintf(sim,"  %c ",65);
 
      if(qz<=cl[1].number)
          fprintf(sim,"[%c]",bloc[cl[1].order[qz]].seq[ml]); 
    } 
  }
  if(tally==0){fprintf(sim,"NONE\n\n\n\n");}else fprintf(sim,"\n\n\n\n");



/****************************************************************************//*
    Report Conserved Individual Sub-group Positions ...
*//****************************************************************************/

  fprintf(sim,"******************\n");
  fprintf(sim,"*2* CONSERVATION *\n");
  fprintf(sim,"******************\n\n");

  fprintf(sim,"* Conserved across alignment\n");
  sto=0;ngaps=10;tally=0;
  for(ml=1;ml<count+1;++ml){ 
    tsp=0;
    if((intcons[1][ml]>=consval)&&(intcons[1][ml]<point+1)){
      if(sto!=ml){
        fprintf(sim,"\n(%3d)",ml);
        sto=ml;
      }
      tally++;

      fprintf(sim,"  %c  ",65);
      fprintf(sim,"(%2d)",intcons[1][ml]);
      fprintf(sim,"   %c-",65);
 
      fprintf(sim,"[");
      for(qx=0;qx<ptype.syno+1;++qx)cd[qx]=0;
      msto=0;posto=0;
      while(resipos[ml].resiclust[1][posto]!='\0')posto++;
      msto=posto;
      for(posto=0;posto<msto;++posto){
        qy=0;rchrlen=0;
        while((qy<ptype.syno)&& 
              (ptype.aas[qy]!=
               resipos[ml].resiclust[1][posto]))
          qy++;
        comb=ptype.aas[qy];
        if(comb==' ')comb = '_';
        if(cd[qy]==0){
          fprintf(sim,"%c",comb);
          rchrlen++;
        }
        cd[qy]=1;
      }
      fprintf(sim,"]");
      tsp=tsp+rchrlen;
 
/*calculate conserved properties*/

      numbs=0;
      for(qy=0;qy<ptype.pno;++qy)er[qy]=0;
      for(qy=0;qy<ptype.syno;++qy)
        if(cd[qy]>0){ 
          numbs++;
          for(qz=0;qz<ptype.pno;++qz) 
            if(ptype.apm[qz].ptype[qy]==1)er[qz]++;
         }

      qz=0;qy=0;qx=0;
      while(qy<ptype.pno){
        while((qy<ptype.pno)&&(er[qy]!=numbs)&&(qy<ptype.pno))qy++; 
        if(qy<ptype.pno){  
          if(qx==0){
            for(my=0;my<ngaps-tsp;++my)fprintf(sim," ");
            fprintf(sim," Cons: ");
            fprintf(sim,"%-14s",ptype.pnames[qy]);
          } else {
            fprintf(sim,"                    ");
            for(my=0;my<ngaps;++my)fprintf(sim," ");
            fprintf(sim,"           ");
            fprintf(sim,"%-14s",ptype.pnames[qy]);
          }
          qy++;
        }
        fprintf(sim,"\n");
        qx=1;
      }
    }
  }
  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");



/****************************************************************************//*
    Report Unconserved Individual Sub-group Positions ...
*//****************************************************************************/

  fprintf(sim,"******************\n");
  fprintf(sim,"*3* UnConserved  *\n");
  fprintf(sim,"******************\n\n");

  fprintf(sim,"* Unconserved across alignment\n");
  sto=0;tally=0;
  for(ml=1;ml<count+1;++ml){ 
    if(intcons[1][ml]<consval){
      none=0;
      if(sto!=ml){
        fprintf(sim,"\n(%3d)",ml);
        sto=ml;
      }
      tally++;
      if(intcons[1][ml]<0){
        fprintf(sim,"   %c ",65);
      } else { 
        fprintf(sim,"   %c ",65);
        fprintf(sim,"(%2d)",intcons[1][ml]);
      }
      fprintf(sim,"  %c-",65);
      fprintf(sim,"[");
      for(qx=0;qx<ptype.syno+1;++qx)cd[qx]=0;
      for(qx=1;qx<cl[1].number+1;++qx){
        qy=0;
        while((qy<ptype.syno)&&
              (ptype.aas[qy]!=bloc[cl[1].order[qx]].seq[ml]))qy++;
        if(cd[qy]==0){
          if(ptype.aas[qy]!=' '){fprintf(sim,"%c",ptype.aas[qy]);}
          else fprintf(sim,"_"); 
          none++;
        }
        cd[qy]=1;
      }
      fprintf(sim,"]");
      for(mz=0;mz<(10-none);++mz)fprintf(sim," ");
    } 
  }


  if(tally==0){fprintf(sim,"\nNONE\n\n\n");}else fprintf(sim,"\n\n\n");



/****************************************************************************//*
    END ...
*//****************************************************************************/

  fclose(sim);

  free((char*) er);
  free((char*) cd);
}
