C********************************************************
      SUBROUTINE GTEST(ITEST,INUMB,IERR)
C--------------------------------------------------------
C Subroutine to read in a list of definde regions from
C channel ITEST. INUMB is the number of sequences to be
C aligned.  IERR is the output channel for error messages
C
C Author: G. J. Barton
C---------------------------------------------------------
C
      include 'params.blk'
      include 'tester.blk'
C
      CHARACTER*80 BUFF
C
      INTEGER BLEN,NTEST,ITEST,IERR,INUMB
      LOGICAL ERROR
C
      NTEST = 0
1     CONTINUE
      CALL SCHAR(1,BUFF)
      READ(ITEST,100,END = 1000)BUFF
100   FORMAT(A80)
      CALL DBLANK(BUFF,BLEN)
      IF(INDEX(BUFF,'>').GT.0)THEN
        NTEST = NTEST +1
        NREG = 0
        IF(NTEST.GT.MSEQ2)THEN
          CALL AMESS(IERR,1,'NUMBER OF TEST REGIONS EXCEEDS MAX ',
     -               1,'E')
        END IF
        TIDENT(NTEST)=BUFF(1:20)
      ELSE
        NREG = NREG +1
        IF(NREG.GT.MAXREG)THEN
          CALL AMESS(IERR,1,'NUMBER OF TEMPLATE REGIONS '//
     -               'EXCEEDS MAX ALLOWED ',1,'E')
          STOP
        END IF
C       write(6,*)'buff  = ',buff
        CALL IIREAD(BUFF,TEMLAT(1,NREG,NTEST),
     -                   TEMLAT(2,NREG,NTEST),
     -                   ',',IERR,ERROR)
C       write(6,*)'temlat = ',temlat(1,nreg,ntest),temlat(2,nreg,ntest)
        IF(ERROR)THEN
          CALL AMESS(IERR,1,'ERROR DECODING TEMPLATES ',1,'E')
          STOP
        END IF
      END IF
      GOTO 1
C
1000  CONTINUE
      IF(NTEST.NE.INUMB)THEN
        CALL AMESS(IERR,1,
     -  'NUMBER OF TEMPLATES DOES NOT MATCH NUMBER OF'//
     -  ' SEQUENCES ',1,'E')
        WRITE(IERR,*)'NO OF SEQS = ',
     -                INUMB,' NUMBER OF TEMPLATES = ',NTEST
        STOP
      END IF
C
      CALL AMESS(IERR,1,'Template details read ',1,'-')
C
      END
C





