C**********************************************************
      SUBROUTINE FSEQMF(IIN,IERR,EOF,ERROR,SCAN,HEADS,
     -                  SEQ,N,NCHAR,HEADER,TITLE)
C**********************************************************
C Author: Geoff Barton
C
C Fetch_SEQuence_from_Main_File
C
C Subroutine to read a sequence from a PIR style database
C file ie line 1 >P1;ident
C         line 2 Title
C       lines3-n free format one letter code sequence
C                terminates with a *.
C
C IIN =    Input channel for database file
C IERR=    Output channel for error messages
C EOF =    .t. if end of file encountered
C ERROR =  Error flag .t. if error occurs when reading
C SCAN  =  .t. if all sequences in file are to be read
C       =  .f. if a specific identifier is to be searched
C HEADS =  character string containing identifier to look for
C          of file
C SEQ   =  character*1 array to hold sequence
C N     =  dimension of passed array
C
C---------------------------------------------------------
C
      INTEGER IIN,IERR,ISTAR,BEND,I,N
      CHARACTER*500 BUFF,TBUFF*1
      CHARACTER*26 LETTER
      CHARACTER*(*) HEADS,HEADER
      CHARACTER*(*) TITLE
      CHARACTER*(*) SEQ(N)
C
      LOGICAL ERROR,
     -        END,
     -        EOF,SCAN
C
      INTEGER NCHAR,NERR,ios
C
      DATA LETTER/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
C
100   FORMAT(A)
101   FORMAT(A)
C
c      write(6,*)'IIN',IIN,'IERR',IERR,'SCAN',SCAN
c      write(6,*)'iin',iin,'ierr',ierr,'scan',scan
C
C     read the header line
999   CONTINUE
C     initialise buff
      CALL SCHAR(1,BUFF)
      ios = 0
c      write(ierr,*)' Input channel',IIN
      READ(IIN,100,iostat=ios,END=1005)BUFF
      if(ios.ne.0)then
        write(ierr,*)'Error in fseqmf: can''t read line from seqfile'
        write(ierr,*)'NOT end of file'
        error = .true.
        return
      end if
      IF(INDEX(BUFF,'>').GT.0)THEN
C     this is a header line
         END=.FALSE.
         NCHAR=0
         NERR=0
C        store header
         HEADER=BUFF(1:10)
C        if we are not reading all seqs
         IF(.NOT.SCAN)THEN
           IF(HEADER.NE.HEADS)THEN
             GOTO 999
           END IF
         END IF
C        read the title line
         READ(IIN,101,iostat=ios,END=1005)TITLE
         if(ios.ne.0)then
           write(ierr,*)'Error reading title line from seqfile'
           error = .true.
           return
         end if
C        read the sequence lines
1        CONTINUE
         CALL SCHAR(1,BUFF)
         READ(IIN,100,iostat=ios,END=1005)BUFF
         if(ios.ne.0)then
            write(ierr,*)'Error reading sequence line from seqfile'
            error = .true.
            return
         end if
         ISTAR=INDEX(BUFF,'*')
         BEND = 0
         IF(ISTAR.GT.0)THEN
            END=.TRUE.
            IF(ISTAR.NE.1)THEN
              BEND=ISTAR-1
            END IF
         ELSE
C           this line does not contain terminator '*' so
C           find last non-blank characte in buff
            CALL FINEND(BUFF,BEND)
         END IF
C        put all chars is uppercase
         CALL CUCASE(BUFF)
C        remove any non-alphabetic characters
         DO 10,I=1,BEND
            TBUFF=BUFF(I:I)
            IF(INDEX(LETTER,TBUFF).GT.0)THEN
               NCHAR=NCHAR+1
C              check for length of seq exceeding N
               IF(NCHAR.GE.N)THEN
                 ERROR=.TRUE.
                 RETURN
               END IF
               SEQ(NCHAR)=TBUFF
            END IF
C           note that error codes are not stored but could be.
10       CONTINUE
         IF(END)THEN
           GOTO 2000
         ELSE
           GOTO 1
         END IF
      END IF
      GOTO 999
C
1000  WRITE(IERR,*)'ERROR READING LINE FROM SEQUENCE DATABASE'
      ERROR=.TRUE.
      RETURN
1005  WRITE(IERR,*)
      EOF=.TRUE.
      RETURN
2000  END


