C********************************************************
      SUBROUTINE MULTB(KPOS)
C--------------------------------------------------------
C Author G.J. Barton: Copyright 1987 All rights reserved.
C
C Aligns a sequence block with each entry in the database
C file
C
C--------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
      LOGICAL ERROR,EOF
C
      integer kpos
C
C
      INTEGER IBSEQ,IFIN,ALOC,BLOC,
     -        NEWKPOS,I,J,IDIV,NR,ENDFIN
C
      REAL OMATCH
C
C --  seed, number of seqs analysed, number of calls to fseqmf
      INTEGER*4 JSEED,NUMCAL
      integer*4 numsca,il

C
C --common block common to just multb and wpatt number of 
      common /mwpatt/ numsca,il
C
      integer pminlen
C
      ERROR =.FALSE.
      EOF =.FALSE.
      NUMSCA = 0
      NUMCAL = 0
C
      NR = 0
      kpos = 0
      ibseq = 0
      ifin = 0
      aloc = 0
      bloc = 0
      newkpos = 0
      idiv = 0
      nr = 0
      il = 0
C
C -- 11/11/1993  If comnd(20) then get the minimum length of bloc
C      this is used to test sequence lengths.  if shorter the skip
C
C -- 24/8/1995   Change this back to allow matching to sequences of any 
C    length.
C      pminlen = numb(1)
C      do 222, i=1,numb(1)
C         pminlen = pminlen + gapmin(i)
C 222  continue
      pminlen = 0

C
C --  do the clever stuff for each seq in turn
C
C --  idiv defines the number of sequences in the bloc
      IDIV= (RBLOC(2,1)-RBLOC(1,1)+1)
C      WRITE(6,*)'IDIV ',IDIV
C     should be equal to inumb
C     ibseq is the index of the sequence being aligned
C      write(6,*)'inumb',inumb
      IBSEQ=INUMB+1
      KPOS=NUMB(INUMB)
      IFIN = INUMB
C
C --  if a pattern format file has been requested, then output the 
C     pattern info in a suitable format
      if(comnd(200))then
         call wpatt(0,ibseq)
      end if
C
C --  set up the lookup table
      IF (COMND(39))THEN
C        use the lookup table defined by Read_lookup command
      ELSE IF(COMND(21))THEN
C        gjscan style lookup table based on identity
         CALL MLOOK2(IBSEQ,IFIN,IDIV,KPOS)
      ELSE IF(COMND(22))THEN
C        set up weight matrix
         CALL MLOOK3(IBSEQ,IFIN,IDIV,KPOS)
      ELSE IF(COMND(24))THEN
C        set up matrix based on conservation
         CALL MLOOK4(IBSEQ,IFIN,IDIV,KPOS)
      ELSE IF(COMND(36))THEN
C        set up matrix based on simple frequencies
         call mlook5(IBSEQ,IFIN,IDIV,KPOS)
      ELSE
         if(comnd(210))then
C          get modified weights according to accessibility values
           call alook(ibseq,ifin,idiv,kpos)
         else
           CALL MLOOK(IBSEQ,IFIN,IDIV,KPOS)
         end if
      END IF
C
C --  write out the current lookup table if requested
      IF(COMND(23))THEN
        CALL WLOOK(KPOS)
      END IF
C
C --  write out the current lookup table to machine readable file
C     and stop
      if(comnd(37))then
        if(comnd(43))then
C          save brief format lookup table
           call bslook(kpos)
        else
C          save full format lookup table
           call slook(kpos)
        end if
        stop
      end if
C
C      do 3452,i=1,kpos
C         write(6,897)(lookup(i,k),k=1,23)
C3452  continue
C897   format(1x,23f5.2)
C
C --  get each seq in turn from the database file
1     CONTINUE
C --  if randomisations requested then set counter to zero
      IF(COMND(18))THEN
        NR = 0
        JSEED = -3121597
      END IF
      ERROR =.FALSE.
      NUMSCA = NUMSCA+1
      NUMCAL = NUMCAL+1
      IF(COMND(25))THEN
C --    read from a binary database
C        CALL FSEQBF(21,IERR,SEQ(1,IBSEQ),MAXDIM+10,NUMB(IBSEQ),
C     -  IDENTS(IBSEQ),NAMES(IBSEQ),EOF,ERROR)
      ELSE
      CALL FSEQMF(21,IERR,EOF,ERROR,.TRUE.,' ',
     -SEQ(1,IBSEQ),maxdim+10,NUMB(IBSEQ),IDENTS(IBSEQ),
     -NAMES(IBSEQ))
      END IF

C
C
C     write(6,*)(seq(jkl,ibseq),jkl=1,numb(ibseq))
C --
C      write(6,*)idents(ibseq),numb(ibseq)
C      write(6,*)names(ibseq)
C
C --
      IF(EOF)THEN
        NUMSCA = NUMSCA-1
        NUMCAL = NUMCAL-1
        WRITE(IOUT,1001)NUMSCA,NUMCAL
1001    FORMAT(1X,'Number of sequences scanned :',I5,/
     -         1X,'    out of a total of       :',I5,
     -            ' present in the database')
        RETURN
      END IF
      IF(ERROR .or. pminlen .gt. numb(ibseq) )THEN
C       go back for another seq.  Note an error will occur
C       if the sequence being read is .ge. maxdim+10
C       The seqence is skipped if too short or too long
C     
        NUMSCA=NUMSCA-1
        GOTO 1
      END IF
C
C --  ignore this seq if MINSEQ flag has been set and this is LT
C     the minimum total pattern length
      IF(COMND(29))THEN
        IF(NUMB(IBSEQ).LT.MINPAT)THEN
           NUMSCA=NUMSCA-1
           GOTO 1
        END IF
      END IF
C
C --  marker for randomisation loop
2     CONTINUE
C
C --  write out current seq id and title
      IF(NR.EQ.0)THEN
        if(.not.comnd(201))then
           CALL AMESS(IOUT,0,IDENTS(IBSEQ)//': '//
     -          NAMES(IBSEQ)(1:ENDFIN(NAMES(IBSEQ))),0,' ')
        end if
      END IF
C
C --  chek to see if done
      IF(NR.EQ.NRANS+1)THEN
        CALL STATS(RMATCH,NRANS,RMEAN,RSD)
C
C --    if a file of the random scores as been requested then
C       write out the scores
        IF(COMND(27))THEN
          WRITE(27,2232)
2232       FORMAT(1X,'!DATA_TYPE=XY_ONLY'/
     -           1X,'!HIST,X=5000:1.0'/
     -           1X,'!START_DATA')
          WRITE(27,2243)(RMATCH(I),I=1,NRANS)
2243       FORMAT(1X,F10.2,',0')
          WRITE(27,2234)
2234       FORMAT(1X,'!END_DATA')
        END IF
C       output the details
        if(.not.comnd(201))then
           WRITE(IOUT,234)NUMB(INUMB),NUMB(IBSEQ),
     -          OMATCH,OMATCH/MIN(NUMB(INUMB),NUMB(IBSEQ)),
     -          RMEAN,RSD,(OMATCH-RMEAN)/RSD
234        FORMAT(1X,I5,I5,6F10.2)
        else
           write(isout,2233)omatch,
     -           idents(ibseq)(2:endfin(idents(ibseq)))
 2233      format(1x,f10.2,1x,a)
        end if
        GOTO 1
      END IF
C
C --  put this seq into integer form
      CALL KONSEQ(IBSEQ)
C      write(6,*)(iseq(ibseq,jkl),jkl=1,numb(ibseq))
C
C      write(6,*)'pattern before scomp'
C      do 56,jkl=1,kpos
C         write(6,*)jkl,(iseq(lkj,jkl),lkj=1,inumb)
C56    continue
C
C --  get rid of any unwanted gaps
      CALL SCOMP(IBSEQ,KPOS,INUMB)
C      write(6,*)'pattern after scomp'
C
      if(comnd(34))then
C --    perform the segment comparison using iwind window
C       length
        call segcom(kpos,numb(ibseq),ibseq)
        call amess(iout,1,'Segment comparison completed',1,'-')
        stop
      end if

C
C --  run recurs
      IF(COMND(20))THEN
C
C        write(7,*)'seq before recd'
C        write(7,*)'kpos',kpos,'numb(ibseq)',numb(ibseq),'iseq',
C     -             (iseq(ibseq,jkl),jkl=1,numb(ibseq))
C        write(7,*)
C
C        write(7,*)'lookup table before recd'
C        call wlook(kpos)

C
        CALL RECD(KPOS,NUMB(IBSEQ),ALOC,BLOC,IBSEQ)
C
C        write(7,*)'lookup table after recd'
C        call wlook(kpos)
C
C        write(7,*)
C        write(7,*)'seq after recd'
C        write(7,*)'match',match,'bloc'
C        write(7,*)'kpos',kpos,'numb(ibseq)',numb(ibseq),'iseq',
C     -             (iseq(ibseq,jkl),jkl=1,numb(ibseq))
      ELSE
C --     if variable gaps have been set the call sgap to set the pens
         IF(COMND(19))THEN
           CALL SGAP(KPOS)
C --       call version of recurs which copes with variable gaps
           CALL RECG(KPOS,NUMB(IBSEQ),GAP,
     -               ALOC,BLOC,IBSEQ,IFIN,IDIV)
         ELSE
C --       use the ordinary recurs
           CALL RECALL(KPOS,NUMB(IBSEQ),GAP,MATCH,
     -               ALOC,BLOC,IBSEQ,IFIN,IDIV)
         END IF
      END IF
      IF(NR.GT.0)THEN
        RMATCH(NR)=MATCH
      ELSE
        OMATCH = MATCH
      END IF
C
C --  loop over the number of levels of pattern requested to be
C     displayed default nlevel is 1
      do 873,il=1,nlevel
         if(comnd(35).and.(nlevel.gt.1))then
C --       get rid of unwanted blanks
           call scomp(ibseq,kpos,inumb)
C --       locate the next best scoring pattern start point
           call fbest(bloc,omatch,numb(ibseq))
           if(.not.comnd(200))then
C --         don't write out if we are saving to pattern file
             write(iout,320)il,nlevel,omatch,bloc
320          format(1x,'Alignment ##',i5,' of ',i5,
     -              '  Score: ',f7.2,'  Start point: ',i5)
           end if
         end if
C --     align the current seq with the bloc but don't if
C        we have not requested sequence output
         IF((PFULL.OR.PPRET).AND.(NR.EQ.0))THEN
           IF(COMND(20))THEN
             ALOC = 0
           END IF
           CALL ALMUL(KPOS,NUMB(IBSEQ),ALOC,BLOC,NEWKPOS,
     -                IBSEQ,IFIN)
C
           KPOS=NEWKPOS
C
C --       rename ioutsq members to iseq
           DO 109,J=1,KPOS
              DO 109,I=1,IBSEQ
                 ISEQ(I,J)=IOUTSQ(I,J)
109        CONTINUE
C
C --
           CALL KONBAK(KPOS,IBSEQ)
           if(comnd(200))then
C --         we want to write out the pattern alignments in a form suitable
C            for program pattern
             call wpatt(kpos,ibseq)
C --         deny the option of writing alignments too
           else
             IF(TEST) CALL GCHECK(IBSEQ,kpos,6)
             IF(PFULL)THEN
                CALL WRITE6(KPOS,IBSEQ,comnd(15),comnd(16))
             END IF
             IF(PPRET)CALL PRETTY(iout,NHORIZ,IBSEQ,KPOS)
             IF(TEST) CALL WCHECK(IOUT,RBLOC(1,2),KPOS)
           end if
         END IF
C
C --
         IF(.NOT.COMND(18))THEN
            if(.not.comnd(201))then
C -   -     for now just write out the scores
               WRITE(IOUT,234)NUMB(INUMB),NUMB(IBSEQ),OMATCH,
     -              OMATCH/MIN(NUMB(INUMB),NUMB(IBSEQ)),
     -              0.0,0.0,0.0
            else
               write(isout,2233)omatch,
     -         idents(ibseq)(2:endfin(idents(ibseq)))
            end if
         ELSE
C --        randomise the sequence and go back
            NR = NR +1
            CALL SCRAMC(SEQ(1,IBSEQ),NUMB(IBSEQ),JSEED)
            GOTO 2
         END IF
873   continue
C
C --  go back for the next seq
      GOTO 1
C
      END
C
C***************************************************************
      subroutine fbest(bloc,omatch,lenb)
C---------------------------------------------------------------
C Looks in the oldcol array over lenb, the length of the
C sequence identified for the highest scoring element.  The index
C of this element is returned as bloc score, omatch, then the element is
C set to the minimum value of the oldcol array
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
C
      integer i,bloc,lenb
      real omatch, omin,omax
C
      call rmm(oldcol,lenb,omin,omax)
C
      omatch = oldcol(1)
      bloc = 1
      do 10,i=2,lenb
         if(oldcol(i).ge.omatch)then
            omatch = oldcol(i)
            bloc = i
          end if
10    continue
C
      oldcol(bloc) = omin
C
      end
C
