C*****************************************************************
      SUBROUTINE pret2(A,B,NCHAR)
C------------------------------------------------------------------
C Author:  G. J. Barton
C
C Writes out aligned sequences ASEQ and BSEQ to unit IO OUTLEN
C residues per line. A and B are the number ofthe sequence A,B
C respectively - NCHAR is the length of the aligned sequences
C-----------------------------------------------------------------
      include 'params.blk'
      include 'seqcha.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
      INTEGER   STCHN,LINCR,LSTART,LFIN,LEN,NLIN,I,J
      INTEGER   NCHAR,A,B

C
      STCHN =1
      LINCR =nhoriz
      LSTART=STCHN
      LFIN  =STCHN+LINCR-1
      LEN   =NCHAR
      NLIN  =INT(((NCHAR-STCHN)+1)/LINCR)+1
C
C -- write slightly prettier output if the seqs are being written
C    to a file other than the standard output
C
      if(comnd(33))then
        write(ipseq,*)
        write(ipseq,823) a,names(a)
        write(ipseq,823) b,names(b)
823     format(1x,i5,1x,a80)
        write(ipseq,*)
      end if
      DO 10,J=1,NLIN
         IF(LFIN.GT.LEN)LFIN=LEN
           WRITE(ipseq,61)A,IDENTS(A),
     -                 LSTART,(ASEQ(I),I=LSTART,LFIN)
           WRITE(ipseq,61)B,IDENTS(B),
     -                 LSTART,(BSEQ(I),I=LSTART,LFIN)
         IF(LFIN-STCHN.EQ.LEN-1)RETURN
         LSTART=LSTART+LINCR
         LFIN=LFIN+LINCR
         WRITE(ipseq,*)
10    CONTINUE
      write(ipseq,100)
C --  10/9/91 change format from A12 to A20 to accommodate idents
61    FORMAT(1X,I4,A20,2X,I4,100a1)
100   FORMAT(1X,//)
      END
C
