C**************************************************************
      SUBROUTINE ALOOK(IBSEQ,IFIN,IDIV,KPOS)
C--------------------------------------------------------------
C This is the same as routine MLOOK except that...
C
C Modify the lookup table according to the accv() accfac and
C acccut values
C 
C The accv array contains integer relative accessibilities.
C If a position is below the acccut value then all positive 
C values in the lookup table at that position are multiplied 
C by accfac.  This should have the effect of boosting the importance
C of matching buried residues with similar types of residues in the
C query.
C
C Sample command file
C acc_file=1PLC.acc    A file with each line containing an integer accessiblity
C acc_factor=2.0       The factor to multiply +ve lookup table values by
C acc_cut=10           The lower Accessibility cutoff
C acc_opt=1            Define option for scoring
C acc_upper_cut=80     Define upper accessibility cutoff
C
C accopt = 1 then multiply positive scores by acc_factor when acval < acc_cut
C accopt = 2 then multiply positive and negative scores by acc_fac
C            this increases the contrast of the lookup table at buried positions
C
C accopt = 3 then do as accopt = 2, but also multiply when accessibility is .gt.accucut
C            The reasoning is that exposed positions should stay exposed and so be 
C            boosted too.
C
C Author:  G. J. Barton 30/8/1995
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'dayhof.blk'
      include 'param2.blk'
      include 'gapmis.blk'
C
C --
C
      integer ibseq,ifin,idiv,kpos

      INTEGER I,J,K
      REAL TEMP

      i=0
      j=0
      k=0
      temp=0.0
C
C --  loop over each amino acid type including gaps
      DO 10,I=0,23
C
C --     loop over the aligned positions
         DO 20,J=1,KPOS
C
C --        calculate mean score at this postion
            TEMP=0.0
            DO 30,K=1,IFIN
               IF(K.EQ.IBSEQ)GOTO 30
               TEMP = TEMP + DAY(ISEQ(K,J),I)
30          CONTINUE
            LOOKUP(J,I)=TEMP/IDIV
C --        cater for old version of program
            IF(COMND(26))THEN
              LOOKUP(J,I)=INT(LOOKUP(J,I))
            END IF
C --        Apply the accessibility modification to the lookup table
            if(accopt .eq. 1)then
               if(accv(j) .le. acccut)then
                  if(lookup(j,i) .gt. 0)then
                     lookup(j,i) = lookup(j,i) * accfac
                  end if
               end if
            else if(accopt .eq. 2)then
               if(accv(j) .le. acccut)then
                  lookup(j,i) = lookup(j,i) * accfac
               end if
            else if(accopt .eq. 3)then
               if(accv(j) .le. acccut)then
                  lookup(j,i) = lookup(j,i) * accfac
               else if(accv(j) .ge. accucut)then
                  lookup(j,i) = lookup(j,i) * accfac
               end if 
            end if
20       CONTINUE
10    CONTINUE
C
      END
C

