C********************************************************
      SUBROUTINE FSEQS(IIN,IOUT,NSEQ,TOTSEQ)
C--------------------------------------------------------
C Subroutine to read in a set of sequences from a PIR
C format file:  Makes use of routine FSEQMF repeatedly
C Geoff Barton May (1987)
C
C IIN input channel
C IOUT output messages/errors
C NSEQ number of sequences read BEFORE calling this routine
C TOTSEQ number of sequences in TOTAL AFTER this routine
C--------------------------------------------------------
C
      include 'params.blk'
      include 'seqcha.blk'
      include 'intseq.blk'
      include 'gapmis.blk'
C
C
      INTEGER IIN,IOUT,NSEQ,TOTSEQ,k
C
      LOGICAL ERROR,EOF
C
      character*5 blank
      ERROR = .FALSE.
      EOF   = .FALSE.
      blank = '     '
C
1     CONTINUE
      NSEQ = NSEQ +1
      IF(NSEQ.GT.MAXSEQ)THEN
        CALL AMESS(IOUT,1,'MAXIMUM NUMBER OF SEQUENCES READ'//
     -  ' IGNORING REST OF SEQ FILE',1,'I')
        TOTSEQ=NSEQ-1
        RETURN
      END IF
C
C --
C      write(6,*)'Input channel from fseqs IIN',IIN
C      write(6,*)'IOUT',IOUT
C      write(6,*)'EOF',EOF
C      write(6,*)'ERROR',ERROR
C      write(6,*)' '
      CALL FSEQMF(IIN,IOUT,EOF,ERROR,.TRUE.,blank,
     -SEQ(1,NSEQ),MAXDIM,NUMB(NSEQ),IDENTS(NSEQ),NAMES(NSEQ))
C
C      write(6,*)'SEQ number ',NSEQ
C      write(6,*)'SEQ id ',idents(nseq)
C      write(6,*)'SEQ name',names(nseq)
C      write(6,*)'LEN seq',numb(nseq)
C      write(6,*)'SEQ ',(seq(k,nseq),k=1,numb(nseq))
C
C --
      IF(EOF)THEN
        TOTSEQ=NSEQ-1
        RETURN
      END IF
C
C --
      IF(ERROR)THEN
        CALL AMESS(IOUT,1,'ERROR READING SEQUENCE FROM SEQ FILE',
     -  1,'E')
        STOP
      END IF
C
C --
      GOTO 1
C
      END
C
