C*****************************************************************
      SUBROUTINE MASTER
C-----------------------------------------------------------------
C Author:  G. J. Barton (1987)
C
C reads input directives from unit=ICOM
c all units defined in param2.blk include file
C
C Input lines are acted upon as they are read, thus any errors are
C identified immediately!
C
C key words
C
C    OUTPUT_FILE        (defines file for output of alignment)
C    SEQ_FILE           (master sequence file)
C    MATRIX_FILE        (amino acid pairscore file eg DAYHOFF)
C    CONSTANT           (integer constant to add to MATRIX_FILE)
C    GAP_PENALTY        (real constant gap penalty)
C    ITERATIONS         (integer constant number of iterations)
C    PRINT_VERTICAL     (logical .t. for vertical printing of alignment)
C    PRINT_HORIZONTAL   (logical .t. for horizontal format output)
C    MAX_HORIZ          (integer max number of residues per line)
C    ORDER_FILE         (defines order file)
C    TEST_FILE          (defines file containing test regions)
C    GAP_MASK           (defines value for scoring a residue with a
C                        gap already inserted..) int1,int2,int3,,,,
C
C
c version 2.1  includes options to read one prealigned block of
C              sequences which is subsequently compared to all
C              seq's in database file
C
C    BLOCK_FILE/PATTERN  (block filename,int) int is the iteration
C                         number to be read
C                        must be defined FIRST if seqs are to be
C                        appended to the existing bloc
C                        if /pattern is present then the program
C                        will read a predefined pattern of
C                        residues with predefined gap-lengths
C                        from the block file (see FBLOC)routine
C                        for details of syntax
C
C    MINSEQ=T            This flag operates when block_file is in operation
C                        if present then the program checks the
C                        total pattern length.  If a sequence is longer
C                        than the total pattern length then it is not
C                        processed
C
C    DATABASE/brief,N= fname   database file containing at least one seq
C                        to align with the block each seq taken in
C                        turn N= number of randomisations to perform
C                        per sequence.
C                        If the /brief modifier is present the
C                        program requires a cdb created format
C                        database (see subroutine fseqbf)
C
C    CONSPLOT= MZ/GB     if present it switches the plotting of a
C                        conservation profile ON mean and SD of
C                        conservation values are also calculated
C                        MZ = conservation by marketas algorithm
C                        GB = conservation by geoff's method
C                        MZ is default
C
C    GAP_FACTOR=real     factor to be applied to the gap penalty
C                        array over the regions specified by the
C                        flags set when reading from a block file
C                        see subroutine fbloc for details.
C
C    FREQ_FILE=          file containing amino acid occurence
C                        probabilities.  If this file is defined and
C                        a block file is also defined then
C                        the lookup table is derived by first finding
C                        the frequency of occurence of an amino acid at
C                        each aligned position then dividing by the
C                        number of sequences and the probability of
C                        finding that particular amino acid  (see
C                        Dodd and Egan J. Mol Biol 1987 194,557-564
C
C    SHOW_LOOKUP         If this flag is present the current lookup
C                        table is printed
C
C    CONSCORE=T          If this is present then scoring of a seq v
C                        another is done using conservation numbers
C                        rather than the defined matrix_file
C
C    RANDOM_FILE= fname  If present, the results of any randomisations
C                        are written in GENPLOT format to this file
C
C
C Version 2.2  The first serious mods using the SUN wokstation
C              changes are intended to allow portability back to the
C              VAX without heartache.....
C
C    MODE=MULTIPLE/SCAN/PAIRWISE
C                        This flag indicates the desired program mode
C                        Its only purpose is to identify inconsistencies
C                        in the supplied input.  eg. a missing SEQ_FILE in
C                        mode=MULTIPLE...
C
C    PAIRWISE_RANDOM=min,max,incr
C                        Min, max and increment for performing
C                        randomisations on pairwise comparisons
C                        If only one value is present after the
C                        = then this is taken as the number of
C                        randomizations
C
C    PAIRWISE_TIMER=     If present then timings are written for each
C                        pair of proteins
C
C    PAIRWISE_SELF=      If present then the sequence is also compared
C                        to itself
C
C    SEGMENT_SIZE=int,file
C                        defines the length of a segment for segment
C                        comparison mode.  This flag also enables the
C                        mode.  Segment comparisons may only be performed
C                        between a block_file and a sequence
C                        int= the length of window
C                        file = the name of a file to write the comparison
C                        details to for subsequent analysis using
C                        DIAPLOT.
C
C    PATTERN_LEVEL = int specifies that the top int matches between
C                        a pattern and the sequence are reported
C                        and also alignments printed if the print flags
C                        are set..
C
C    FREQSCORE =         flag to indicate that simple frequency scoring
C                        is to be applied to generate the lookup_table
C
C    SAVE_LOOKUP = file  flag to indicate that the lookup table should be
C                        saved to 'file'.  The program then stops
C
C    SAVE_LOOKUP/BRIEF=file save lookup table to file in brief format.
C
C    S_LOOKUP_COMMENT = string
C                        indicates the comment string to start the file
C                        specified by the SAVE_LOOKUP command (default is
C                        the filename.
C
C    READ_LOOKUP = fname
C                        specifies the filename of an explicitly stated lookup
C                        table to be read in.
C
C    TREE_FILE  = fname
C                        read information on which pairs of sequences to be
C                        aligned and in what order.  In other words allow 
C                        alignment to follow a specifically stated evolutionary
C                        tree.
C
C    NUMERATE =          flag that indicates the virtically printed 
C                        sequences should be numbered
C
C    PSFILE =            fname of file containing sequences to compare
C                        pairwise to the database file
C
C    USE_END_PEN=        11/8/93 - Include end gap penalties in tree mode (comnd(205))
C                        
C--------------------------------------------------------------------
C
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'conser.blk'
      include 'tester.blk'
      include 'param2.blk'
C
      include 'speedo.blk'
C
      CHARACTER*4 INCHAR,RECHAR*8
      integer     endfin,z
      parameter   (z=0)
      logical     logcom
C---------------------------------------------------------------------
      INTEGER     I,X,NCOMM,IOS,K1,K2,NEXP,NNEXP
      INTEGER     temi
C
C --  number of seqs so far read ( in BLOCK mode),Total number of seqs
C     so far.,number of blocs,iteration number selected for this block
      INTEGER NSEQ,TOTSEQ,NBLOC,ITNO
      LOGICAL ERROR,GMF
C
      character*80 buff
C --  common blocks common only to master and mast2
      common /immast/ i,x,ncomm,ios,k1,k2,nexp,nnexp,nseq,temi,
     -                totseq,nbloc,itno
      common /lmmast/ error,gmf
      common /cmmast/ buff
C--------------------------------------------------------------------
      ERROR=.FALSE.
      NSEQ   = 0
      TOTSEQ = 0
      ITNO = 1
      NBLOC = 0
C --  default mode is multiple alignment
      MODES = 1
C --  random runs in pairwise mode
      prmin = 0
      prmax = 0
      princ = 1
C --  initialise the number of residues printed horizontally (def = 100)
      nhoriz = 100
C --  initialise the output channel for pairwise alignments
      ipseq = iout
C --  initialise the number of pattern levels to 1
      nlevel = 1
C --  initialize the number of iterations
      nits = 1
C
C --  initialise stuff to do with accessibilities
      nacc = 0
      acccut = 15
      accopt = 1
      accucut = 80
      accfac = 2.0
C
C
C
C --  initialise the command line counter and command line flag array
      NCOMM=Z
      CALL INITL(COMND,MAXCOM,.FALSE.)
C
C --  initialise the gap mask array
      CALL INITI(GMASK,MAXMAS,0)
C
C --  read each line from unit= ICOM
1     CONTINUE
      CALL SCHAR(1,BUFF)
      READ(ICOM,100,ERR=2000,END=1000)BUFF
100   FORMAT(A)
C      write(0,*)'Processing command: ',buff
      X = INDEX(BUFF,'=')
      IF(X.EQ.Z)THEN
        CALL AMESS(IERR,1,'No equals sign in command line! ',
     -    1,'e')
        CALL AMESS(IERR,0,BUFF(1:ENDFIN(BUFF)),1,'E')
        GOTO 3000
      END IF
      call cucase(buff(:x))
      IF(NCOMM.EQ.Z.AND.INDEX(BUFF(1:X),'OUTPUT_FILE').EQ.Z)THEN
        CALL AMESS(IERR,1,'YOU MUST SPECIFY THE OUTPUT '//
     -  'FILE COMMAND FIRST!!',1,'E')
        STOP
      END IF
      IF(INDEX(BUFF(1:X),'OUTPUT_FILE').GT.Z)THEN
C --    get output filename and open
C --    Keep UNIX happy and convert to lowercase
        NCOMM=NCOMM+1
        COMND(1)=.TRUE.
        OPEN(UNIT=IOUT,FILE=BUFF(X+1:),
     -  IOSTAT=IOS)
        IF(IOS.NE.0)THEN
          CALL AMESS(IERR,1,'ERROR OPENING OUTPUT FILE'//
     -    BUFF(1:ENDFIN(BUFF)),1,'e')
          GOTO 3000
        END IF
C --    write program info to output file
        call ampinf
      ELSE IF(INDEX(BUFF(1:X),'MATRIX_FILE').GT.Z)THEN
C --    initialise pairscore matrix then read it from file
        NCOMM=NCOMM+1
        COMND(2)=.TRUE.
        CALL INITI(DAY,24*24,0)
C --    open file for read
        call ropen(IPS,'OLD',BUFF(X+1:),IOS)
        IF(IOS.NE.0)THEN
          CALL AMESS(IERR,1,'Error opening pair score file '//
     -    BUFF(1:ENDFIN(BUFF)),1,'e')
          GOTO 3000
        END IF
C
C --    if we have read the UP.MAT file then set a flag
C       this flag in pattern mode decides how the
C       lookup table is generated (see MLOOK)
        IF((INDEX(BUFF,'UP.MAT').GT.0).or.
     -     (index(buff,'up.mat').gt.0))THEN
          COMND(21)=.TRUE.
        END IF
C -- get title and amino acid order
        READ(IPS,23)TITLE
        call schar(1,buff)
        read(ips,23)buff
        call dblank(buff,i)
        if(i.ne.23)then
          call amess(ierr,1,'Matrix file must define 20 amino acids'//
     -    ' + B, Z and X',1,'e')
          stop
        end if
        do 310,i=1,23
           acids(i) = buff(i:i)
310     continue
23      FORMAT(A80)
        DO 200,K1=1,23
           READ(IPS,210)(DAY(K2,K1),K2=1,23)
200     CONTINUE
210     FORMAT(23I3)
        CALL AMESS(IMESS,1,'matrix file read',0,'-')
        CALL AMESS(IOUT,0,TITLE,1,'-')
        CLOSE(IPS)
C
      ELSE IF(INDEX(BUFF(1:X),'SEQ_FILE').GT.Z)THEN
C --    open and read the sequences all from one file
        IF(COMND(14))THEN
          CALL AMESS(IOUT,0,'Will align seqs with the block',
     -    1,'-')
        END IF
        NCOMM=NCOMM+1
        COMND(3)=.TRUE.
C --    open file for read
        call ropen(isq,'OLD',BUFF(X+1:),IOS)
        IF(IOS.NE.0)THEN
          CALL AMESS(IERR,1,
     -    'Error opening sequence file '//
     -    BUFF(X+1:ENDFIN(BUFF)),
     -    1,'e')
          GOTO 3000
        END IF
        CALL AMESS(IOUT,0,'Sequence file : '//BUFF(X+1:ENDFIN(BUFF)),
     -  1,'-')
        CALL FSEQS(ISQ,IERR,NSEQ,INUMB)
        CLOSE(ISQ)
      ELSE IF(INDEX(BUFF(1:X),'ORDER_FILE').GT.Z)THEN
C --    open the order file and read the info from it
        NCOMM=NCOMM+1
        COMND(4)=.TRUE.
        call ropen(IORD,'OLD',BUFF(X+1:),IOS)
        IF(IOS.NE.0)THEN
          CALL AMESS(IERR,1,
     -    'Error opening order file '//
     -    BUFF(X+1:ENDFIN(BUFF)),
     -    1,'e')
          GOTO 3000
        END IF
C       order the sequences according to .ORD file
        CALL ARRAN(IERR,IORD,INUMB)
        CALL AMESS(IOUT,0,'Order file : '//BUFF(X+1:ENDFIN(BUFF)),
     -  1,'-')
        CLOSE(IORD)
      ELSE IF(INDEX(BUFF(1:X),'TEST_FILE').GT.Z)THEN
C --      open the defined test file (contains defined regions for all
C         sequences - max of mseq2 sequences)
          NCOMM=NCOMM+1
          COMND(5)=.TRUE.
          call ropen(ITEST,'OLD',BUFF(X+1:),IOS)
          IF(IOS.NE.0)THEN
            CALL AMESS(IMESS,1,'ERROR OPENING TEST REGION FILE '//
     -      BUFF(X+1:ENDFIN(BUFF)),1,'E')
            GOTO 3000
          END IF
          TEST = .TRUE.
          IF(TEST)CALL GTEST(ITEST,INUMB,IERR)
          CALL AMESS(IOUT,0,'Test data file : '//BUFF(X+1:ENDFIN(BUFF)),
     -    1,'-')
          CLOSE(ITEST)
      ELSE IF(INDEX(BUFF(1:X),'CONSTANT').GT.Z)THEN
C --      get the constant to add to the matrix
          NCOMM=NCOMM+1
          error = .false.
          COMND(6)=.TRUE.
          CALL INTCOM(BUFF,CONST,ERROR)
          IF(ERROR)THEN
            CALL AMESS(IERR,1,'ERROR READING CONSTANT '//
     -      BUFF(X+1:ENDFIN(BUFF)),1,'E')
            GOTO 3000
          END IF
          CALL AMESS(IOUT,0,'Constant : '//INCHAR(CONST),
     -    1,'-')
      ELSE IF(INDEX(BUFF(1:X),'GAP_PENALTY').GT.Z)THEN
C --      read the gap penalty
          NCOMM=NCOMM+1
          COMND(7)=.TRUE.
          error = .false.
          CALL REACOM(BUFF(X+1:),GAP,ERROR)
          IF(ERROR)THEN
            CALL AMESS(IERR,1,'ERROR READING GAP PENALTY'//
     -      BUFF(X+1:ENDFIN(BUFF)),1,'E')
            GOTO 3000
          END IF
          CALL AMESS(IOUT,0,'Gap penalty : '//RECHAR(GAP,2),
     -    1,'-')
      ELSE IF(INDEX(BUFF(1:X),'ITERATIONS').GT.Z)THEN
C --      read the number of iterations required
          COMND(8)=.TRUE.
          error = .false.
          NCOMM=NCOMM+1
          CALL INTCOM(BUFF(X+1:),NITS,ERROR)
          IF(ERROR)THEN
             CALL AMESS(IERR,1,'ERROR READING NUMER OF '//
     -       'ITERATIONS '//BUFF(X+1:ENDFIN(BUFF)),1,'E')
             GOTO 3000
          END IF
          CALL AMESS(IOUT,0,'Number of iterations chosen : '//
     -    INCHAR(NITS),1,'-')
      ELSE IF(INDEX(BUFF(1:X),'PRINT_VERTICAL').GT.Z)THEN
C --      read logical flag for vertical printing
          NCOMM=NCOMM+1
          error = .false.
          COMND(9)=.TRUE.
          PFULL=.true.
          IF(PFULL)THEN
            CALL AMESS(IOUT,0,
     -      'Vertical format output selected ',
     -      1,'-')
          END IF
      ELSE IF(INDEX(BUFF(1:X),'PRINT_HORIZ').GT.Z)THEN
C --      read logical flag for horizontal printing
C         this is an anachronism (only the print_horiz is necc)
          NCOMM=NCOMM+1
          COMND(10)=.TRUE.
          PPRET= .true.
          IF(PPRET)THEN
            CALL AMESS(IOUT,0,
     -      'Horizontal format output selected',
     -      1,'-')
          END IF
          if(index(buff(1:x),'/PATTERN').gt.z)then
C --         we have defined a pattern printing option so read and open
C --         the fname to save the pattern alignment details
C             write(0,*)'writing message to file'
             call amess(iout,0,'Pattern alignment output file: '//
     -                  buff(x+1:endfin(buff)),1,'-')
C             write(0,*)'message written - opening pattern file'
C             write(0,*)'called:',buff(x+1:endfin(buff))
             open(ipatt,file=buff(x+1:endfin(buff)),
     -             iostat=ios)
C     -            status='new',iostat=ios)
C             write(0,*)'file open - checking status'
C	     write(0,*)'ios: ',ios
             if(ios.ne.0)then
                call amess(ierr,1,'Error opening file',1,'e')
                stop
             end if
C             write(0,*)'status checked - setting comnd(200)'
             comnd(200)=.true.
C             write(0,*)'comnd(200) set'
          end if 
      ELSE IF(INDEX(BUFF(1:X),'MAX_HORIZ').GT.Z)THEN
          CALL INTCOM(BUFF(X+1:),NHORIZ,ERROR)
          COMND(11)=.TRUE.
          IF(ERROR)THEN
            CALL AMESS(IERR,1,'ERROR DECODING MAX_HORIZ COMMAND',
     -      1,'E')
            GOTO 3000
          END IF
          IF(NHORIZ.GT.MAXHOR)THEN
             CALL AMESS(IERR,1,'MAX NUMBER OF CHARACTERS PERMITTED'//
     -       ' IS '//INCHAR(MAXHOR),1,'E')
             GOTO 3000
          END IF
          CALL AMESS(IOUT,0,
     -    'Max number of residues per line of output'//
     -    ' :'//INCHAR(NHORIZ),1,'-')
      ELSE IF(INDEX(BUFF(1:X),'GAP_MASK').GT.Z)THEN
          NMASK=0
          NEXP=X+1
          GMF=.FALSE.
          COMND(12)=.TRUE.
379       CONTINUE
          NMASK=NMASK+1
          NNEXP=INDEX(BUFF(NEXP:),',')+NEXP-2
          IF((NNEXP-NEXP+2).EQ.0)THEN
            GMF=.TRUE.
            NNEXP=ENDFIN(BUFF)+1
          END IF
          CALL INTCOM(BUFF(NEXP:NNEXP),GMASK(NMASK),ERROR)
          IF(GMF)THEN
             WRITE(IOUT,1179)(GMASK(I),I=1,NMASK)
1179         FORMAT(1X,'Gap mask defined = ',30I3)
          ELSE
             NEXP=NNEXP+2
             GOTO 379
          END IF
      ELSE IF(INDEX(BUFF(1:X),'SHOW_MATRIX').GT.Z)THEN
          COMND(13)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'BLOCK_FILE').GT.Z)THEN
          IF(INDEX(BUFF(1:X),'PATTERN').GT.Z)THEN
C            this is a pattern file
             CALL AMESS(IOUT,0,'Pattern file requested ',1,'-')
             COMND(20)=.TRUE.
          END IF
          IF(COMND(3))THEN
            CALL AMESS(IERR,1,'You MUST define the block file '//
     -      'before the sequence file!!',
     -      1,'E')
            STOP
          END IF
          if(index(buff(1:x),'NOCHANGE').gt.z)then
C           read the block file without uppercasing everything
            comnd(210)=.TRUE.
          else
            comnd(210)=.false.
          end if
          COMND(14)=.TRUE.
          call ropen(ISQ,'OLD',BUFF((X+1):INDEX(BUFF,',')-1),
     -    IOS)
          IF(IOS.NE.0)THEN
            CALL AMESS(IERR,1,'ERROR OPENING BLOCK FILE',1,'E')
            CALL AMESS(IERR,0,BUFF(1:ENDFIN(BUFF)),1,'E')
            STOP
          END IF
          CALL AMESS(IERR,0,'Block file defined: '//
     -    BUFF(X+1:endfin(buff)),
     -    1,'-')
C
C--       check if the comma is present
          IF(INDEX(BUFF,',').EQ.0)THEN
             CALL AMESS(IERR,0,
     -       'No iteration number defined assume 1',
     -       1,'-')
             ITNO = 1
          ELSE
          CALL INTCOM(BUFF(INDEX(BUFF,',')+1:),ITNO,ERROR)
          IF(ERROR)THEN
            CALL AMESS(IERR,1,'ERROR READING BLOCK FILE ITERATION'//
     -      ' NUMBER!',1,'E')
            CALL AMESS(IERR,0,BUFF(1:ENDFIN(BUFF)),1,'E')
          END IF
          END IF
          NBLOC = NBLOC + 1
          CALL FBLOC(ISQ,NSEQ,TOTSEQ,ITNO)
          IF(COMND(29))THEN
            WRITE(IERR,*)'MINIMUM PATTERN LENGTH IS',MINPAT
            WRITE(IERR,*)'NO SEQS .LT. ',
     -                   'this will be included in comparison'
          END IF
          CLOSE(ISQ)
C         keep record of start and end of bloc
          RBLOC(1,NBLOC) = NSEQ+1
          RBLOC(2,NBLOC) = TOTSEQ
          NSEQ = TOTSEQ
          INUMB=TOTSEQ
          IF(NBLOC.GT.1)THEN
             CALL AMESS(IERR,1,
     -      'YOU CAN ONLY DEFINE ONE BLOCK FILE',
     -       1,'E')
             STOP
          END IF
      ELSE IF(INDEX(BUFF(1:X),'MINSEQ').GT.0)THEN
          COMND(29)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'CONSPLOT').GT.0)THEN
          CALL AMESS(IOUT,0,'Conservation profile enabled ',1,'-')
          COMND(15)=.TRUE.
          IF(INDEX(BUFF,'GB').GT.0)THEN
             CALL AMESS(IOUT,0,'GB type conservation',1,'-')
          ELSE
             CALL AMESS(IOUT,0,'MZ type conservation',1,'-')
             COMND(16)=.TRUE.
          END IF
      ELSE IF(INDEX(BUFF(1:X),'DATABASE').GT.0)THEN
          IF(INDEX(BUFF(1:X),'/BRIEF').GT.0)THEN
C --        set flag to read compact format database
            COMND(25)=.TRUE.
            CALL AMESS(IOUT,0,'Brief format database specified',
     -      1,'-')
            CALL AMESS(IOUT,0,'THIS OPTION IS NOT AVAILABLE',
     -      1,'-')
            STOP
          END IF
          CALL AMESS(IOUT,0,'Database file: '//buff(x+1:),
     -     1,'-')
C
          IF(COMND(25))THEN
          call ropen(21,'OLD',BUFF(X+1:),IOS)
          ELSE
          call ropen(21,'OLD',BUFF(X+1:),IOS)
          END IF
C
          IF(IOS.NE.0)THEN
            CALL AMESS(IERR,1,'ERROR OPENING DATABASE',1,'E')
            STOP
          END IF
          COMND(17)=.TRUE.
C --      check for the offer of random runs
          IF(INDEX(BUFF(1:X),',').GT.0)THEN
            CALL INTCOM(BUFF(INDEX(BUFF,',')+1:X-1),NRANS,ERROR)
            IF(ERROR)THEN
              CALL AMESS(IERR,1,
     -        'ERROR READING NUMBER OF RANDOM RUNS',1,'E')
               STOP
            END IF
            CALL AMESS(IOUT,0,'Randomisations per entry: '//
     -      inchar(nrans),1,'-')
            IF(NRANS.GT.MAXRAN)THEN
               CALL AMESS(IERR,1,
     -         'NUMBER OF RANDOMISATIONS EXCEEDS MAX ALLOWED',
     -         1,'E')
               STOP
            END IF
            COMND(18)=.TRUE.
          END IF
      ELSE IF(INDEX(BUFF(1:X),'GAP_FACTOR').GT.0)THEN
C --      read the gap factor and set comnd(19) t
          CALL REACOM(BUFF(X+1:),QFAC,ERROR)
          IF(ERROR)THEN
            CALL AMESS(IERR,1,'ERROR READING GAP FACTOR',1,'E')
            STOP
          END IF
          COMND(19)=.TRUE.
          CALL AMESS(IOUT,0,'Gap factor defined as: '//
     -    RECHAR(QFAC,3),1,'-')
      ELSE IF(INDEX(BUFF(1:X),'FREQ_FILE').GT.0)THEN
C --      read the frequency file
          call ropen(12,'OLD',BUFF(X+1:),IOS)
          IF(IOS.NE.0)THEN
            CALL AMESS(IERR,1,'ERROR OPENING FREQ_FILE',1,'E')
            CALL AMESS(IERR,0,BUFF(X+1:ENDFIN(BUFF)),1,'E')
            STOP
          END IF
          CALL RFREQ(12)
          COMND(22)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'CONSCORE').GT.0)THEN
          COMND(24)=.TRUE.
          CALL AMESS(IOUT,0,'Conservation scoring to be used',1,'-')
      ELSE IF(INDEX(BUFF(1:X),'SHOW_LOOKUP').GT.0)THEN
C --      set flag to print the weight matrix/lookup table
          COMND(23)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'OLD_VERSION').GT.0)THEN
C --      set flag to indicate old style scoring
          COMND(26)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'RANDOM_FILE').GT.0)THEN
C --      open the file to store the results of random runs
          OPEN(UNIT=27,FILE=BUFF(X+1:),STATUS='NEW',
     -    IOSTAT=IOS)
          IF(IOS.NE.0)THEN
             CALL AMESS(IERR,1,'ERROR OPENING RANDOM_FILE',1,'E')
             STOP
          END IF
          COMND(27)=.TRUE.
      ELSE IF(INDEX(BUFF(1:X),'MODE').GT.0)THEN
          CALL CUCASE(BUFF)
          IF(INDEX(BUFF,'MULTIPLE').GT.0)THEN
             MODES=1
          ELSE IF(INDEX(BUFF,'PAIRWISE').GT.0)THEN
             MODES=3
          ELSE IF(INDEX(BUFF,'SCAN').GT.0)THEN
             MODES=2
          END IF
      else if(index(buff(:x),'PAIRWISE_RANDOM').gt.0)then
C --      get the min, max and incr for randomisations
          temi = index(buff,',')-1
C --      check if comma exists if so then the single number
C         is the number of randomizations
          if(temi.le.0)then
            call intcom(buff(x+1:),prmin,error)
            if(error)then
              call amess(ierr,1,'Error reading: '//
     -        buff(:endfin(buff)),1,'e')
              stop
            end if
            prmax = prmin
            princ = 1
          else
C --        read the min, max and increment for randomizations
            call intcom(buff(x+1:temi),prmin,error)
            call iiread(buff(temi+2:),prmax,princ,',',ierr,error)
            if(error)then
              call amess(ierr,1,'Error reading: '//
     -        buff(:endfin(buff)),1,'e')
              stop
            end if
          end if
          comnd(30) = .true.
          call amess(ierr,0,'Pairwise randomizations defined',
     -    0,'-')
          write(ierr,81)prmin,prmax,princ
81        format(1x,'Min: ',i4,' Max: ',i4,' Increment: ',i4)
      else if(index(buff(:x),'PAIRWISE_TIMER').gt.0)then
          call amess(ierr,0,'Timing enabled for pairwise mode',
     -    1,'-')
          comnd(31) = .true.
      else if(index(buff(:x),'PAIRWISE_SELF').gt.0)then
          call amess(ierr,0,'Self comparisons will be performed',
     -    1,'-')
          comnd(32) = .true.
      else if(index(buff(:x),'PAIRWISE_ALIGN_FILE').gt.0)then
          ipseq = 19
          open(unit=ipseq,file=buff(x+1:),iostat=ios)
          if(ios.ne.0)then
            call amess(ierr,1,'Error: cannot open file '//
     -      buff(x+1:endfin(buff)),1,'e')
            stop
          else
            call amess(ierr,0,'Will write alignments to file '//
     -      buff(x+1:endfin(buff)),1,'-')
            comnd(33) = .true.
          end if
      else if(index(buff(:x),'USE_END_PEN').gt.0)then
          comnd(205) = .true.
          call amess(imess,1,
     -    'Gaps at ends will be weighted (tree mode only)',1,' ')
      else
C --      call the continuation of master
          call mast2
      end if
C
      GOTO 1
C
1000  CONTINUE
C
C --  all commands read so check that there are sufficient
C     commands for the type of mode.
C
      if(modes.eq.1)then
        call amess(imess,1,'MULTIPLE mode has been defined',
     -  1,' ')
      else if(modes.eq.2)then
        call amess(imess,1,'SCAN mode has been defined',
     -  1,' ')
      else if(modes.eq.3)then
        call amess(imess,1,'PAIRWISE mode has been defined',
     -  1,' ')
      end if
      call amess(imess,0,'Checking minimal command set',1,'-')
C
      call comchk
C
      call amess(imess,0,'Commands satisfy this mode..',1,'-')
C
C
      RETURN
C --  error reading from command file
2000  CONTINUE
      CALL AMESS(IERR,1,'ERROR READING FROM COMMAND FILE',
     -           1,'e')
      STOP
C --  error reading or decoding a command line
3000  CONTINUE
      CALL AMESS(IERR,1,'ERROR DECODING COMMAND LINE',1,'e')
      STOP
C
      END
C

