C***************************************************************
      SUBROUTINE PLATE(IASQ,np,LEN)
C---------------------------------------------------------------
C G. J. Barton (1985)
C New version for multiple alignment program  2/87
C
C IASQ       integer current sequence identifier
C nreg     number of frames defined in the template
C NP         number of the PLATE to be written (=1 or2)
C LEN        length of aligned sequence (ie KPOS)
C
C THIS SUBROUTINE TAKES THE ALIGNED SEQUENCE ARRAY 'OUTSEQ'
C TOGETHER WITH A 2D TEMPLATE ARRAY 'TEMLAT'(DIMENSIONS
C ISF =2,nreg= NUMBER_OF_FRAMES) AND OUTPUTS AN INTEGER
C ARRAY TEMSEQ(LENGTH_OF_OUTSEQ=LEN) HAVING THE SPECIFIED
C TEMPLATE RESIDUES NUMBERED SEQUENTIALLY.
C
C EG.
C
C    SEQUENCE:    A  H  K  L  L  M  P  P  S  V  S
C
C    TEMLAT(1,1)=3
C    TEMLAT(2,1)=6
C
C    TEMSEQ:      0  0  1  2  3  4  0  0  0  0  0
C
C---------------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'tester.blk'
C
C
      LOGICAL     START
      integer np,ind,intem,icount,i,len,iasq
C---------------------------------------------------------------
C INITIALISE ITERATION VARIABLES
C IND = CURRENT POSITION OF POINTER IN OUTSEQ
C INTEM= CURRENT TEMPLATE
C START = INDICATES BEGINNING OF A TEMPLATE RANGE
C---------------------------------------------------------------
      IND=0
      INTEM=1
      ICOUNT=0
      START=.FALSE.
      DO 12,I=1,LEN
            plates(i,np)=0
12    CONTINUE
      DO 10,I=1,LEN
           IF(iseq(IASQ,I).gt.0)THEN
              IND=IND+1
              IF(IND.EQ.TEMLAT(1,INTEM,TEMPT(IASQ)))START=.TRUE.
              IF(START)THEN
                 ICOUNT=ICOUNT+1
                 plates(i,np)=ICOUNT
                 IF(IND.EQ.TEMLAT(2,INTEM,TEMPT(IASQ)))THEN
                     START=.FALSE.
                     INTEM=INTEM+1
                     IF(INTEM.EQ.(nreg+1))THEN
                         RETURN
                     END IF
                  END IF
               END IF
           END IF
10      CONTINUE
        END
C---------------------------------------------------------------
