C************************************************************
      subroutine rlook
C------------------------------------------------------------
C (C) G. J. Barton 1987.
C
C Subroutine to read explicitly stated lookup table details
C from a file having the following format.  Each entry represents
C the position within the alignment defined in the current
C block_file
C
C line 1:      comment line (max 80 characters)
C entry:       > n                             signals start of entry n
C A 8,R 9,G 20,.......,  Entry line, gives weights for each amino acid
C at this position.  the entry line may be continued.  Each amino acid
C weight is defined by the amino acid one letter code, followed by a
C real or integer constant followed by a comma.
C
C Use standard format if possible, ie the format produced by the
C complementary routine 'slook'
C (a1,f6.1)
C
C---------------------------------------------------------------------
C
C
      include 'params.blk'
      include 'param2.blk'
      include 'matloc.blk'
      include 'gapmis.blk'
      include 'dayhof.blk'
C
      integer aindx,cindx,icurr,cstrt,i,ip1,ios
      character*132 buff
C - change *4 to *6 (21/4/92)
      character*6   inchar
C      character*6 temchar
      logical error
C
      character*24  cacid
C
C --  store the current values of acids in the cacid character string
C     convert the blank character to '-'
      do 20,i=0,23
         ip1 = i+1
         if(acids(i).eq.' ')then
           cacid(ip1:ip1)='-'
         else
           cacid(ip1:ip1) = acids(i)
         end if
20    continue
C
C -- read the comment line
      read(iolook,100,iostat=ios)lcmnt
100   format(a80)
      if(ios.ne.0)then
        call amess(ierr,1,
     -  'Error reading comment from lookup table file',1,'e')
        stop
      end if
C
C -- read until next '>' and process
1     continue
      read(iolook,101,iostat=ios)buff
101   format(a)
      if(ios.ne.0)then
        call amess(iout,0,'Lookup table has been read in',0,' ')
C        write(0,*)icurr
C        temchar = inchar(icurr)
C        write(0,*)inchar(icurr)
        call amess(iout,0,inchar(icurr)//' lines',1,'-')
        return
      end if
      if(index(buff,'>').gt.0)then
C --    this is a new entry
        call intcom(buff(index(buff,'>')+1:),icurr,error)
        cstrt = 0
        cindx = 0
        goto 1
      else
C --    this is a line containing weights for amino acids loop
C       until the end of line then go back for the next line
        call cucase(buff)
2       continue
        cstrt = cindx + 1
        cindx = index(buff(cstrt:),',')
        if(cindx.eq.0)then
C --      end of line condition go read the next line
          goto 1
        end if
        cindx = cindx + cstrt - 1
C --    locate the character amino acid name then record the weight
        do 10,i=cstrt,cindx-1
           aindx = index(cacid,buff(i:i))
           if(aindx.gt.0)then
              aindx = aindx - 1
              call reacom(buff(i+1:cindx-1),
     -                    lookup(icurr,aindx),error)
              goto 2
           end if
10      continue
      end if
C --  should never get here!!
      call amess(ierr,1,'Error reading amino acid weights',1,'e')
      stop
C
      end
C





