C***********************************************************
      LOGICAL FUNCTION ABLANK(STRING)
C-----------------------------------------------------------
C Author: Geoff Barton
C
C looks at STRING if there is a non-blank character then
C ABLANK = .FALSE. else ABLANK = .true.
C-----------------------------------------------------------
C
      INTEGER I
      CHARACTER*(*) STRING
C
      ABLANK = .TRUE.
      DO 10,I=1,LEN(STRING)
         IF(STRING(I:I).NE.' ')THEN
           ABLANK = .FALSE.
           RETURN
         END IF
10    CONTINUE
C
      END
C********************************************************
      SUBROUTINE AMESS(OUT,HEADER,MESS,FOOTER,CHR)
C--------------------------------------------------------
C Author: Geoff Barton
C
C Outputs to unit OUT, HEADER*blank lines,
C                      MESS   a character string
C                      FOOTER*blank lines
C Blank lines may be specified to contain
C the length of the complete non-blank line*CHR
C eg stars '*'
C-------------------------------------------------------
C
      CHARACTER*(*) MESS
      CHARACTER*1   CHR
      INTEGER       OUT,HEADER,FOOTER,LENGTH,I
C
      CALL FINEND(MESS,LENGTH)
      DO 10,I=1,HEADER
         CALL WLINE(OUT,LENGTH,CHR)
10    CONTINUE
      WRITE(OUT,60)MESS
60    FORMAT(1X,A)
      DO 20,I=1,FOOTER
         CALL WLINE(OUT,LENGTH,CHR)
20    CONTINUE
      END
C
C********************************************************
      SUBROUTINE AMESSI(OUT,HEADER,MESS,FOOTER,INT,CHR)
C-------------------------------------------------------
C Author: Geoff Barton
C
C Outputs to unit OUT, HEADER*blank lines,
C                      MESS   a character string
C                      INT an integer (max 8 digits)
C                      FOOTER*blank lines
C Blank lines may be specified to contain
C the length of the complete non-blank line*CHR
C eg stars '*'
C-------------------------------------------------------
C
      CHARACTER*(*) MESS
      CHARACTER*1   CHR
      INTEGER       OUT,HEADER,FOOTER,LENGTH,I,INT
C
      CALL FINEND(MESS,LENGTH)
      DO 10,I=1,HEADER
         CALL WLINE(OUT,LENGTH,CHR)
10    CONTINUE
      WRITE(OUT,60)MESS,INT
60    FORMAT(1X,A,I8)
      DO 20,I=1,FOOTER
         CALL WLINE(OUT,LENGTH,CHR)
20    CONTINUE
      END
C
C*******************************************************
      SUBROUTINE BALL(OUT,WIDTH)
C-------------------------------------------------------
C Author: Geoff Barton
C
C writes out the author's particulars.....
C
C Updated May 1991 to Oxford address (long overdue)
C-------------------------------------------------------
      INTEGER OUT,WIDTH
C
      call wline(out,130,'-')
C
      CALL BANNER(OUT,' ',WIDTH,
     -'by',
     -30,'-')
      CALL BANNER(OUT,' ',WIDTH,
     -'Geoffrey J. Barton',
     -30,'-')
      CALL BANNER(OUT,' ',WIDTH,
     -'Laboratory of Molecular Biophysics',
     -30,'-')
      CALL BANNER(OUT,' ',WIDTH,
     -'The Rex Richards Building',
     -30,'-')
      CALL BANNER(OUT,' ',WIDTH,
     -'South Parks Road',
     -30,'-')
      call banner(out,' ',width,
     -'OXFORD OX1 3QU',
     -30,'-')
      CALL BANNER(OUT,' ',WIDTH,
     -'ENGLAND',
     -30,'-')
C
      call wline(out,130,'-')
C
      call banner(out,' ',width,
     -'Please cite:',
     -30,'-')
      Call banner(out,' ',width,
     -'Barton, G. J. (1990) Methods in Enzymology 183, 403-428.',
     -30,'-')
      call banner(out,' ',width,
     -'and also as appropriate:',
     -30,'-')
      call banner(out,' ',width,
     -'Multiple alignment: Barton, G. J. and Sternberg, M. J. E. '//
     -'(1987), J. Mol. Biol., 198, 327-337.',
     -10,'-')
      call banner(out,' ',width,
     -'Flexible Patterns: Barton, G. J. and Sternberg, M. J. E. '//
     -'(1990), J. Mol. Biol., 212, 389-402.',
     -10,'-')
      call banner(out,' ',width,
     -'Structure Dependent Gap-Penalties: '// 
     -'Barton, G. J. and Sternberg, M. J. E.'//
     -' (1987), Prot. Eng., 1, 89-94.',
     -10,'-')
      call wline(out,130,'-')
      call banner(out,' ',width,
     -'THANK YOU',
     -30,'-')

C

C
      END
C
C*************************************************************
      SUBROUTINE BANNER(OUT,PRINTS,PWIDTH,WORDS,FILLEN,FILTYP)
C-------------------------------------------------------------
C Author Geoff Barton
C
C This writes out a line to unit=OUT
C PRINTS is character*1 printer control character
C PWIDTH is INTEGER width of page (max=132)
C WORDS  is CHARACTER*(*) message to be output
C FILLEN is the length of 'filler characters to be applied'
C FILTYP is the type of filler character to be applied (*1)
C
C Example:
C        PRINTS = '1'
C        PWIDTH = 50
C        WORDS  = 'HELLO EVERYONE!'
C        FILLEN = 10
C        FILTYP = '-'
C Output would be:
C        New page, then
C----------       HELLO EVERYONE       ----------
C
C Note:
C        Centering is carried out on the WORDS, which will overwrite
C        any erroneous fillers...
C-------------------------------------------------------------------
C
      INTEGER       OUT,PWIDTH,FILLEN
      CHARACTER*(*) WORDS
      CHARACTER*1   PRINTS,FILTYP
C
      INTEGER       WORDLEN,I,J,START
      CHARACTER*132 LINE
C
      WORDLEN = LEN(WORDS)
      IF(WORDLEN.GE.131.OR.PWIDTH.GT.132)THEN
        CALL AMESS(OUT,2,
     -  'Number of characters supplied to BANNER exceeds page width',
     -  2,'-')
        RETURN
      END IF
      IF(WORDLEN.GE.PWIDTH.OR.FILLEN.GE.PWIDTH)THEN
        CALL AMESS(OUT,2,
     -  'Number of characters requested overflows page width',
     -  2,'-')
        RETURN
      END IF

C
C-----establish start point for writing out WORDS
C
      START = (PWIDTH/2)-(WORDLEN/2)+1
C
      DO 10,I=1,PWIDTH
         LINE(I:I) = ' '
10    CONTINUE
C
      LINE(1:1) = PRINTS
C
      DO 11,I=2,FILLEN+1
         LINE(I:I) = FILTYP
11    CONTINUE
      DO 12,I=PWIDTH-FILLEN,PWIDTH
         LINE(I:I) = FILTYP
12    CONTINUE
C
      J=0
      DO 13,I=START,START+WORDLEN-1
         J=J+1
         LINE(I:I)=WORDS(J:J)
13    CONTINUE
C
      WRITE(OUT,100)(LINE(I:I),I=1,PWIDTH)
100   FORMAT(132A1)
C
      END
C
C******************************************************
      character*(*) function ccase(chara)
C------------------------------------------------------
C Author: Geoff Barton
C
C returns ccase as chara in the inverted case
C If the string contains non-alphabetic characters
C these are left alone.
C
C G. J. Barton Jan(1988)
C------------------------------------------------------
      character*(*) chara
      integer i,ilcc,ilch,uindx,lindx
C
      character*26 upper,lower
      data upper/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      data lower/'abcdefghijklmnopqrstuvwxyz'/
C
      ilcc = len(ccase)
      ilch = len(chara)
      if(ilcc.gt.ilch)then
         call amess(6,1,'Error in function ccase',1,'e')
         stop
      end if
C
      do 10,i=1,ilch
         uindx = index(upper,chara(i:i))
         lindx = index(lower,chara(i:i))
         if(uindx.gt.0)then
           ccase(i:i) = lower(uindx:uindx)
         else if(lindx.gt.0)then
           ccase(i:i) = upper(lindx:lindx)
         else 
           ccase(i:i) = chara(i:i)
         end if
10    continue
C
      end
C**********************************************
      SUBROUTINE CHRCOM(LINE,DEC)
C----------------------------------------------
C Author: Geoff Barton
C
C silly little routine to look at LINE and
C return the first alphabetc character as DEC
C if there is no alphabetic character, then
C dec=' '
C----------------------------------------------
      character*(*) line
      character*(*) dec
      integer ilen,i,lchar
C
      dec=' '
      ilen=len(line)
      do 10,i=1,ilen
         lchar=ichar(line(i:i))
         if(lchar.ne.32)then
           if((lchar.gt.64.and.lchar.lt.91).or.
     -         lchar.gt.96.and.lchar.lt.123)then
               dec=line(i:i)
               return
            end if
          end if
10     continue
       end
C**************************************************************
      integer function cindx(char1,char2)
C--------------------------------------------------------------
C Author: Geoff Barton 
C
C Identifies whether char2 is present in char1 without case 
C sensitivity.  Equivalent to INDEX but not case sensitive
C
C returns the first index of char2 in char1
C
C Uses a slow algorithm 
C
C Copyright (c)
C G. J. Barton Jan 1988
C-------------------------------------------------------------
      character*(*) char1,char2
      integer il1,il2,k,i,kp
      character*1 ccase
C
      cindx = 0
      il1 = len(char1)
      il2 = len(char2)
      if(il2.gt.il1)then
         return
      end if
C
C --  go down char1 looking for each element of char2 in turn
      do 10,i=1,il1-il2+1
        kp = i-1
        do 20,k = 1,il2
          kp = kp + 1
          if((char2(k:k).eq.char1(kp:kp)).or.
     -       (char2(k:k).eq.ccase(char1(kp:kp))))then
             if(k.eq.il2)then
                cindx = i
                return
             end if
          else 
             goto 10
          end if
20      continue
10    continue
C
      end
C
C******************************************************
      SUBROUTINE CLCASE(STRING)
C------------------------------------------------------
C Author: Geoff Barton
C
C Takes the value of STRING*(*) and converts to lowercase
C Non alphabetic characters are left alone
C------------------------------------------------------
C
      CHARACTER*(*) STRING
      CHARACTER*26  LCASE,UCASE
C
      INTEGER I,LENGTH,IPOS
C
      DATA LCASE/'abcdefghijklmnopqrstuvwxyz'/
      DATA UCASE/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
C
      do 10,i=1,len(string)
         ipos = index(ucase,string(i:i))
         if(ipos.eq.0)then
         else
           string(i:i)=lcase(ipos:ipos)
         end if
10    continue
      end

C******************************************************
      SUBROUTINE CUCASE(STRING)
C------------------------------------------------------
C Author: Geoff Barton
C
C Takes the value of STRING*(*) and converts to uppercase
C Non alphabetic characters are left alone
C------------------------------------------------------
C
      CHARACTER*(*) STRING
      CHARACTER*26  LCASE,UCASE
C
      INTEGER I,LENGTH,IPOS
C
      DATA LCASE/'abcdefghijklmnopqrstuvwxyz'/
      DATA UCASE/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
C
      do 10,i=1,len(string)
         ipos = index(lcase,string(i:i))
         if(ipos.eq.0)then
         else
           string(i:i)=ucase(ipos:ipos)
         end if
10    continue
      end

C****************************************************
      SUBROUTINE DBLANK(STRING,LEN)
C----------------------------------------------------
C Author: Geoff Barton
C
C Takes STRING and returns STRING with all blanks
C removed and left-justified.
C LEN is the length of the non-blank portion of
C STRING when returned
C----------------------------------------------------
C
      CHARACTER*(*) STRING
      CHARACTER*1   BLANK
      INTEGER LEN,INDEX1,I
C
      DATA BLANK /' '/
C
      CALL FINEND(STRING,INDEX1)
C
      LEN = 0
      DO 10,I=1,INDEX1
         IF(STRING(I:I).NE.BLANK)THEN
           LEN=LEN+1
           STRING(LEN:LEN)=STRING(I:I)
         END IF
10    CONTINUE
C
      CALL SCHAR((LEN+1),STRING)
C
      END
C

C*******************************************************
      FUNCTION ENDFIN(LINE)
C-------------------------------------------------------
C Author: Geoff Barton
C
C Finds the last non-blank character in LINE and returns
C its position as ENDFIN
C IF THERE IS NO NON BLANK CHARACTER THEN ENDFIN = 0
C--------------------------------------------------------
      CHARACTER*(*) LINE
      CHARACTER*1 BLANK
      INTEGER I,ENDFIN
      DATA BLANK/' '/
C
      ENDFIN = 0
      DO 10,I=LEN(LINE),1,-1
         IF(LINE(I:I).NE.BLANK)THEN
           ENDFIN=I
           RETURN
         END IF
10    CONTINUE
      END
C*******************************************************
      SUBROUTINE FINEND(LINE,INDEX1)
C-------------------------------------------------------
C Author: Geoff Barton
C
C Finds the last non-blank character in LINE and returns
C its position as INDEX1
C IF THERE IS NO NON BLANK CHARACTER THEN INDEX1 = 0
C--------------------------------------------------------
      CHARACTER*(*) LINE
      CHARACTER*1 BLANK
      INTEGER I,INDEX1
      DATA BLANK/' '/
C
      INDEX1 = 0
      DO 10,I=LEN(LINE),1,-1
         IF(LINE(I:I).NE.BLANK)THEN
           INDEX1=I
           RETURN
         END IF
10    CONTINUE
      END
C**********************************************************
      SUBROUTINE FSEQMF(IIN,IERR,EOF,ERROR,SCAN,HEADS,
     -                  SEQ,N,NCHAR,HEADER,TITLE)
C**********************************************************
C Author: Geoff Barton
C
C Fetch_SEQuence_from_Main_File
C
C Subroutine to read a sequence from a PIR style database
C file ie line 1 >P1;ident
C         line 2 Title
C       lines3-n free format one letter code sequence
C                terminates with a *.
C
C IIN =    Input channel for database file
C IERR=    Output channel for error messages
C EOF =    .t. if end of file encountered
C ERROR =  Error flag .t. if error occurs when reading
C SCAN  =  .t. if all sequences in file are to be read
C       =  .f. if a specific identifier is to be searched
C HEADS =  character string containing identifier to look for
C          of file
C SEQ   =  character*1 array to hold sequence
C N     =  dimension of passed array
C
C---------------------------------------------------------
C
      INTEGER IIN,IERR,ISTAR,BEND,I,N
      CHARACTER*500 BUFF,TBUFF*1
      CHARACTER*26 LETTER
      CHARACTER*(*) HEADS,HEADER
      CHARACTER*(*) TITLE
      CHARACTER*(*) SEQ(N)
C
      LOGICAL ERROR,
     -        END,
     -        EOF,SCAN
C
      INTEGER NCHAR,NERR,ios
C
      DATA LETTER/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
C
100   FORMAT(A)
101   FORMAT(A)
C
c      write(6,*)'IIN',IIN,'IERR',IERR,'SCAN',SCAN
c      write(6,*)'iin',iin,'ierr',ierr,'scan',scan
C
C     read the header line
999   CONTINUE
C     initialise buff
      CALL SCHAR(1,BUFF)
      ios = 0
c      write(ierr,*)' Input channel',IIN
      READ(IIN,100,iostat=ios,END=1005)BUFF
      if(ios.ne.0)then
        write(ierr,*)'Error in fseqmf: can''t read line from seqfile'
        write(ierr,*)'NOT end of file'
        error = .true.
        return
      end if
      IF(INDEX(BUFF,'>').GT.0)THEN
C     this is a header line
         END=.FALSE.
         NCHAR=0
         NERR=0
C        store header
C -- 10/9/91 -- change from 10 to 20 characters
         HEADER=BUFF(1:20)
C        if we are not reading all seqs
         IF(.NOT.SCAN)THEN
           IF(HEADER.NE.HEADS)THEN
             GOTO 999
           END IF
         END IF
C        read the title line
         READ(IIN,101,iostat=ios,END=1005)TITLE
         if(ios.ne.0)then
           write(ierr,*)'Error reading title line from seqfile'
           error = .true.
           return
         end if
C        read the sequence lines
1        CONTINUE
         CALL SCHAR(1,BUFF)
         READ(IIN,100,iostat=ios,END=1005)BUFF
         if(ios.ne.0)then
            write(ierr,*)'Error reading sequence line from seqfile'
            error = .true.
            return
         end if
         ISTAR=INDEX(BUFF,'*')
         BEND = 0
         IF(ISTAR.GT.0)THEN
            END=.TRUE.
            IF(ISTAR.NE.1)THEN
              BEND=ISTAR-1
            END IF
         ELSE
C           this line does not contain terminator '*' so
C           find last non-blank characte in buff
            CALL FINEND(BUFF,BEND)
         END IF
C        put all chars is uppercase
         CALL CUCASE(BUFF)
C        remove any non-alphabetic characters
         DO 10,I=1,BEND
            TBUFF=BUFF(I:I)
            IF(INDEX(LETTER,TBUFF).GT.0)THEN
               NCHAR=NCHAR+1
C              check for length of seq exceeding N
               IF(NCHAR.GE.N)THEN
                 ERROR=.TRUE.
                 RETURN
               END IF
               SEQ(NCHAR)=TBUFF
            END IF
C           note that error codes are not stored but could be.
10       CONTINUE
         IF(END)THEN
           GOTO 2000
         ELSE
           GOTO 1
         END IF
      END IF
      GOTO 999
C
1000  WRITE(IERR,*)'ERROR READING LINE FROM SEQUENCE DATABASE'
      ERROR=.TRUE.
      RETURN
1005  WRITE(IERR,*)
      EOF=.TRUE.
      RETURN
2000  END


C*********************************************************************
      subroutine hisplot(array,nval,diff,iout,nbuket,error)
C---------------------------------------------------------------------
C Author: Geoff Barton
C
C Routine to calculate a histogram from the data in real array(nval)
C using a bucket interval of diff, iout is the channel for output
C
C error is returned true if the max number of buckets is exceeded
C
C nbuket is the number of buckets calculated.
C---------------------------------------------------------------------
      integer nval,iout,i,j,maxbuk
      parameter(maxbuk=101)
C
C --
      real array(nval), amax,amin,diff,bmin,buckin(2,maxbuk)
C
C --  
      integer freq(maxbuk), nbuket,maxf,minf
C
C --
      logical error
      character pline*50
C
      data pline/'=================================================='/
C --
      error = .false.
      call rmm(array,nval,amin,amax)
C
      nbuket = int((amax-amin)/diff) + 1
C
      if(nbuket.gt.maxbuk)then
         error = .true.
         return
      end if
      bmin = amin
C
C --set up bucket range array
      do 10, i=1,nbuket
         buckin(1,i) = bmin
         buckin(2,i) = bmin + diff
         bmin = bmin + diff
10    continue
C
C --accumulate the values in buckets
      do 20, i = 1,nval
         do 30,j=1,nbuket
            if((array(i).gt.buckin(1,j)).and.
     -         (array(i).le.buckin(2,j)))then
               freq(j) = freq(j) + 1
               goto 20
            end if
30       continue
20    continue
C
      call imm(freq,nbuket,minf,maxf)
C
C --  plot out the results...
C
C      do 41,i=1,nbuket
C         write(6,*)i,buckin(2,i),freq(i),
C     -   int((float(freq(i))/float(maxf))*50.0)
C41    continue
      do 40,i=1,nbuket
         write(iout,100)i,buckin(2,i),freq(i),
     -   (pline(j:j),j=1,int((float(freq(i))/float(maxf))*50.0))
40    continue
C
100   format(1x,i5,f10.3,i10,' |',50a1)
C
C
      end
C
         
  
C*************************************************************
      subroutine iiread(string,i,j,chr,ierr,error)
C-------------------------------------------------------------
C Author: Geoff Barton
C
C reads two integers from the string separated by chr delimeter
C nowt is an error flag
C ierr is for messages (not used)
C-------------------------------------------------------------
C
      character*(*) string,chr*(*)
C
      integer len,lenchr,ierr,st,fi,endfin
C
      integer i,j
C
      logical error
C
      error=.false.
C
C --  do chek for delimeter, set string limits
      lenchr=len(chr)
      st = index(string,chr)-1
      fi = st+lenchr+1
      if(st.le.0)then
        call amess(ierr,1,'ERROR: no delimeter found in string',
     -  1,' ')
        error = .true.
        return
      end if
C
C --  get the reals
      call intcom(string(1:st),i,error)
      if(error)then
        call amess(ierr,1,'ERROR: reading first int field (iiread)',
     -  1,' ')
        error=.true.
        return
      end if
C
      call intcom(string(fi:endfin(string)),j,error)
      if(error)then
        call amess(ierr,1,'ERROR: reading second int field (iiread)',
     -  1,' ')
        error = .true.
        return
      end if
C
      end
C


C******************************************************
      FUNCTION IMAXA(ARRAY,N)
C------------------------------------------------------
C returns the maximum value present in integer ARRAY
C 
C Author: Geoff Barton
C------------------------------------------------------
C
      INTEGER IMAXA,N,I
      INTEGER ARRAY(N)
C
      IMAXA=ARRAY(1)
      DO 10,I=2,N
         IF(ARRAY(I).GT.IMAXA)THEN
           IMAXA=ARRAY(I)
         END IF
10    CONTINUE
C
      END
C********************************************************
      SUBROUTINE IMM(ARRAY,N,MIN,MAX)
C--------------------------------------------------------
C Author: Geoff Barton
C
C Finds the minimum and maximum values in INTEGER ARRAY
C--------------------------------------------------------
C
      INTEGER N,I
      INTEGER ARRAY(N),MIN,MAX
C
      MIN = ARRAY(1)
      MAX = ARRAY(1)
C
      DO 10,I=2,N
         IF(ARRAY(I).LT.MIN)MIN = ARRAY(I)
         IF(ARRAY(I).GT.MAX)MAX = ARRAY(I)
10    CONTINUE
C
      END
C*************************************************************
      CHARACTER*(*) FUNCTION INCHAR(INTger)
C-------------------------------------------------------------
C Author: Geoff Barton
C
C converts integer INT to character string INCHAR
C the size of integer catered for is definesd by the length
C of inchar MAX NUMBER OF DIGITS IN INT=9
C-------------------------------------------------------------
C
      INTEGER INTger,LENC,MAXINT
      CHARACTER*2 FORM(9)
      DATA FORM/'I1','I2','I3','I4','I5','I6','I7','I8','I9'/
C
      LENC  = LEN(INCHAR)
C
      MAXINT=(10.0**LENC)-1
C
      IF(INTger.GT.MAXINT)THEN
        CALL AMESSI(6,2,'INTEGER TO BIG FOR DEFINED CHAR STRING',
     -       2,INTger,'E')
        STOP
      END IF
C
      WRITE(INCHAR,FMT='('//FORM(LENC)//')')INTger
C
      END
C*********************************************************
      SUBROUTINE INITC(ARRAY,N,CHR)
C---------------------------------------------------------
C Author: Geoff Barton
C
C Initialises all elements and substrings of character
C ARRAY(N) to CHR
C---------------------------------------------------------
C
      INTEGER*4     N,LENC,I,J
C
      CHARACTER*(*) ARRAY(N)
      CHARACTER*1   CHR
C
      LENC = LEN(ARRAY(1))
C
      DO 10,I=1,N
         DO 10,J=1,LENC
            ARRAY(I)(J:J)=CHR
10    CONTINUE
C
      END
C**********************************************************
      SUBROUTINE INITI(ARRAY,SIZ,VAL)
C----------------------------------------------------------
C Author: Geoff Barton
C
C Initialises the ARRAY total dimansions SIZ to value VAL
C----------------------------------------------------------
C
      INTEGER SIZ,VAL,I
      INTEGER ARRAY(SIZ)
C
      DO 10,I=1,SIZ
         ARRAY(I)=VAL
10    CONTINUE
C
      END
C******************************************************************
      SUBROUTINE INITL(ARRAY,NUM,VAL)
C------------------------------------------------------------------
C Author: Geoff Barton
C
C SUBROUTINE TO INITIALISE THE LOGICAL ARRAY LENGTH NUM TO THE
C BOOLEAN VAL
C------------------------------------------------------------------
C
      INTEGER NUM,I
      LOGICAL ARRAY(NUM),VAL
C
      DO 10,I=1,NUM
         ARRAY(I)=VAL
10    CONTINUE
C
      END

C**********************************************************
      SUBROUTINE INITR(ARRAY,NUM,VALUE)
C----------------------------------------------------------
C Author: Geoff Barton
C
C Sets the real ARRAY(NUM) to the VALUE
C----------------------------------------------------------
C
      INTEGER NUM,I
      REAL ARRAY(NUM),VALUE
C
      DO 10,I=1,NUM
         ARRAY(I) = VALUE
10    CONTINUE
C
      END
C*********************************************************
      SUBROUTINE INTCOM(LINE,NUM,NONE)
C---------------------------------------------------------
C Author: Geoff Barton
C
C This routine recieves the LINE and returns
C an integer NUM found in the line
C blanks and any other characters not 0-9
C are removed before returning NUM
C NONE=.true. if no integer is found
CNote: ascii values are assumed as result of ICHAR function
C--------------------------------------------------------
      CHARACTER*(*) LINE
      INTEGER NUM,nlen,ndigit,nmult,i
      LOGICAL NONE,minus
C
      NONE=.FALSE.
      NUM=0
      minus = .false.
C
C if minus sign is present anywhere then take it to be minus
      if (index(line,'-').gt.0)then
          minus = .true.
      end if
C
      NLEN=LEN(LINE)
      NDIGIT=0
      NMULT=1
      DO 10,I=NLEN,1,-1
         LCHAR=ICHAR(LINE(I:I))
         IF(LCHAR.GT.47.AND.LCHAR.LT.58)THEN
           LCHAR=LCHAR-48
           NDIGIT=NDIGIT+1
           NUM=NUM+LCHAR*(10**(NDIGIT-1))
         END IF
10    CONTINUE
      IF(NDIGIT.EQ.0)THEN
        NONE=.TRUE.
      END IF
C
      if(minus)then
        num = -1 * num
      end if
      END




C*************************************************
      SUBROUTINE QMESS(OUT,IN,HEADER,MESS,LINE)
C-------------------------------------------------
C Author: Geoff Barton
C
C Outputs to unit = OUT a message MESS
C reads LINE from unit = IN
C preceeded by a HEADER number of blank lines
C-------------------------------------------------
C
      CHARACTER*(*) MESS
      CHARACTER*(*)  LINE
      INTEGER OUT,IN,HEADER,I
C
      WRITE(OUT,67)(' ',I=1,HEADER)
67    FORMAT(A1)
      WRITE(OUT,60)MESS
60    FORMAT(1X,A,$)
      CALL SCHAR(1,LINE)
      READ(IN,50,END=500,ERR=500)LINE
50    FORMAT(A)
      RETURN
500   CALL AMESS(OUT,1,'Error reading command',1,'e')
      RETURN
      END
C*************************************************************
      SUBROUTINE REACOM(STRING,RNUM,NONE)
C-------------------------------------------------------------
C Author: Geoff Barton
C
C This routine looks for a real number in the STRING and returns
C it as RNUM. NONE is set to .true. if an error occurs, or no
C number is found.
C
C Version 1.0 does not cope with E format numbers
C
C Author G.J. Barton (1987)
C--------------------------------------------------------------
C
      LOGICAL NONE
      REAL    RNUM
      CHARACTER*(*) STRING
      INTEGER IOS,NFORM
C
      CHARACTER*4  FORMS(20)
      DATA FORMS/'1.0','2.0','3.0','4.0','5.0','6.0','7.0','8.0',
     -           '9.0',
     -          '10.0','11.0','12.0','13.0','14.0','15.0','16.0',
     -          '17.0','18.0','19.0','20.0'/
C
      NONE = .FALSE.
C
      IF(LEN(STRING).LE.0)THEN
        NONE=.TRUE.
        write(6,*)'Error - string length le 0 in reacom'
        RETURN
      END IF
      CALL DBLANK(STRING,NFORM)
C
      READ(STRING(1:NFORM),IOSTAT=IOS,
     -FMT='(F'//FORMS(NFORM)//')')RNUM
C
      IF(IOS.NE.0)THEN
        NONE=.TRUE.
        write(6,*)'Error - cannot perform internal read in reacom'
      END IF
C
C
      END


C**********************************************************
      CHARACTER*(*) FUNCTION RECHAR(RNUM,IDEC)
C----------------------------------------------------------
C Takes the real number rnum and converts it to a character
C string RECHAR no checking is done to make sure the
C number does not overflow the function -
C IDEC IS THE NUMBER OF DECIMAL PLACES REQUIRED
C----------------------------------------------------------
C
      REAL RNUM
      INTEGER RDEC,LENGTH,IDEC
C
      CHARACTER*1 F,DOT,INCHAR*2
      DATA F,DOT/'F','.'/
C
      LENGTH = LEN(RECHAR)
C
      CALL SCHAR(1,RECHAR)
      WRITE(RECHAR,
     -FMT='('//F//INCHAR(LENGTH)//DOT//INCHAR(IDEC)//')')RNUM
C
      END
C********************************************************
      SUBROUTINE RMM(ARRAY,N,MIN,MAX)
C--------------------------------------------------------
C Author: Geoff Barton
C
C Finds the minimum and maximum values in REAL ARRAY
C--------------------------------------------------------
C
      INTEGER N,I
      REAL ARRAY(N),MIN,MAX
C
      MIN = ARRAY(1)
      MAX = ARRAY(1)
C
      DO 10,I=2,N
         IF(ARRAY(I).LT.MIN)MIN = ARRAY(I)
         IF(ARRAY(I).GT.MAX)MAX = ARRAY(I)
10    CONTINUE
C
      END
C***************************************************************
      subroutine ropen(io,stat,file,ios)
C---------------------------------------------------------------
C Author: Geoff Barton
C
C routine to open a file for read only.
C 
C This is included to allow easy transfer to the VAX using 
C using the READONLY argument of the OPEN statement.
C
C--------------------------------------------------------------
      integer io,ios
      character*(*) stat,file
C
      open(unit=io,status=stat,file=file,iostat=ios)
C
C VAX specific version
C
C      open(unit=io,status=stat,file=file,iostat=ios,
C     - readonly)
C
      end
C*********************************************************************
      subroutine rscale(array,n,smin,smax,sfact,rmin)
C---------------------------------------------------------------------
C Author: Geoff Barton
C
C routine takes the real array(N) and rescales to put all values
C between smin and smax inclusive
C--------------------------------------------------------------------
      integer n,i
      real array(n),smin,smax,rmin,rmax,sfact,stdev,mean
C
      call rmm(array,n,rmin,rmax)
C
      sfact =  (smax - smin)/(rmax - rmin)
C
      do 10,i=1,n
         array(i) = (array(i) - rmin) * sfact + smin
10    continue
C
      end
C
      


C******************************************************
      SUBROUTINE SCHAR(START,LINE)
C------------------------------------------------------
C START = START OF LINE
C LINE  = CHARACTER STRING TO BE BLANKED FROM START TO
C         LEN(LINE)
C------------------------------------------------------
C
      CHARACTER*(*) LINE
      INTEGER START,I
C
      DO 10,I=START,LEN(LINE)
         LINE(I:I)=' '
10    CONTINUE
      END

C*********************************************************
      SUBROUTINE SCRAM(ISEQ,LEN,jseed)
C---------------------------------------------------------
C Author: Geoff Barton 
C
C Randomises sequence ISEQ using jseed as the first
C seed for the random number generator
C
C This is a general version that uses numerical recipes ran2
C function or similar
C
C---------------------------------------------------------
C
      INTEGER*4 JSEED
      INTEGER LEN,K,J,ITEMP,ISEQ(LEN)
C
      real ran2
      DO 10,K=LEN,2,-1
         J=1+INT(K*ran2(jseed))
         ITEMP=ISEQ(K)
         ISEQ(K)=ISEQ(J)
         ISEQ(J)=ITEMP
10    CONTINUE
C
      END
C

C*********************************************************
      SUBROUTINE SCRAMC(ISEQ,LEN,jseed)
C---------------------------------------------------------
C Author: Geoff Barton
C
C WHERE ISEQ IS A CHARACTER SEQUENCE
C Randomises sequence ISEQ using jseed as the first
C seed for the random number generator
C
C This is a general version that uses the numerical recipes
C random number generator ran2
C---------------------------------------------------------
C
      INTEGER*4 JSEED
      INTEGER LEN,K,J
      CHARACTER*1 ITEMP,ISEQ(LEN)
      real ran2
C
      DO 10,K=LEN,2,-1
         J=1+INT(K*RAN2(jseed))
         ITEMP=ISEQ(K)
         ISEQ(K)=ISEQ(J)
         ISEQ(J)=ITEMP
10    CONTINUE
C
      END
C

C**************************************************************
      SUBROUTINE STATS(ARRAY,LEN,MEAN,STDEV)
C--------------------------------------------------------------
C Author: Geoff Barton
C
C Calculates the MEAN and STandard DEViation for the elements
C of real ARRAY length LEN
C Note: denominator is (N-1)
C---------------------------------------------------------------
C
      INTEGER LEN,I
C
      REAL ARRAY(LEN)
      REAL MEAN,STDEV,SUM,SUMSQ
C
      SUM=0.0
      SUMSQ=0.0
      MEAN=0.0
      STDEV=0.0
      DO 10,I=1,LEN
         SUM=SUM+ARRAY(I)
         SUMSQ=SUMSQ+ARRAY(I)**2
10    CONTINUE
      MEAN=SUM/LEN
      STDEV=SQRT((SUMSQ-SUM**2/LEN)/(LEN-1))
C
      END
C
C**************************************************************
      SUBROUTINE STATS2(ARRAY,LEN,MEAN,STDEV,SKEW,KURT)
C--------------------------------------------------------------
C Author: Geoff Barton
C 
C Calculates the MEAN and STandard DEViation,SKew and
C kurtosis for the elements
C of real ARRAY length LEN
C Note: denominator is (N-1)
C---------------------------------------------------------------
C
      INTEGER LEN,I
C
      REAL ARRAY(LEN)
      REAL MEAN,STDEV,SUM,SUMSQ,SKEW,KURT,SUMF,SUMQ,T3,SDIFF
C
      SUM=0.0
      SUMSQ=0.0
      MEAN=0.0
      STDEV=0.0
      SKEW=0.0
      KURT=0.0
      SUMQ =0.0
      SUMF =0.0
      SDIFF=0.0
      DO 10,I=1,LEN
         SUM=SUM+ARRAY(I)
         SUMSQ=SUMSQ+ARRAY(I)**2
10    CONTINUE
      MEAN=SUM/LEN
      STDEV=SQRT((SUMSQ-SUM**2/LEN)/(LEN-1))
C
C --  work out skew and kurtosis in an inefficient way..
C     get sum of cubes and fourth powers
      DO 20,I=1,LEN
         SDIFF = ARRAY(I)-MEAN
         T3 = SDIFF*SDIFF*SDIFF
         SUMQ  = SUMQ + T3
         SUMF  = SUMF + (SDIFF * T3)
20    CONTINUE
C
C --
      T3=STDEV*STDEV*STDEV
      SKEW = (SUMQ/LEN)/T3
      KURT = ((SUMF/LEN)/(STDEV*T3))-3
C
      END
C
C********************************************************************
      subroutine timer(iout)
C--------------------------------------------------------------------
C Author: Geoff Barton
C
C outputs user time, system time and elapsed time (user +system)
C to standard output channel (unit=6)
C this is a SUN specific routine
C Modified - output goes to iout
C
C timer1 is equivalent to timer2
C---------------------------------------------------------------------
      real tarray(2),dtime
      integer iout
      write(iout,600)dtime(tarray),tarray(1),tarray(2)
600   format(1x,'Times: TOTAL: ',f10.3,
     -                ' USER : ',f10.3,
     -                ' SYSTEM:',f10.3)
      end
C
C********************************************************************
      subroutine timer1(iout)
C--------------------------------------------------------------------
C Author: Geoff Barton
C
C dummy procedure to allow compatibility with VAX version
C 
C outputs user time, system time and elapsed time (user +system)
C to standard output channel (unit=6)
C this is a SUN specific routine
C Modified - output goes to iout
C
C t
C---------------------------------------------------------------------
      real tarray(2),dtime
      integer iout
C
      end
C
C********************************************************************
      subroutine timer2(iout)
C--------------------------------------------------------------------
C Author: Geoff Barton
C
C outputs user time, system time and elapsed time (user +system)
C to standard output channel (unit=6)
C this is a SUN specific routine
C Modified - output goes to iout
C
C timer1 is equivalent to timer2
C---------------------------------------------------------------------
      real tarray(2),dtime
      integer iout
      write(iout,600)dtime(tarray),tarray(1),tarray(2)
600   format(1x,'Times: TOTAL: ',f10.3,
     -                ' USER : ',f10.3,
     -                ' SYSTEM:',f10.3)
      end
C
C***********************************************************
      SUBROUTINE WLINE(OUT,LEN,CHR)
C-----------------------------------------------------------
C Author: Geoff Barton
C
C writes a line of LEN*'CHR's' to unit OUT
C if CHR = ' ' then only writes one ' '
C-----------------------------------------------------------
      CHARACTER*1 CHR
      INTEGER OUT,LEN,I
C
      IF(CHR.EQ.' ')THEN
         WRITE(OUT,60)CHR
      ELSE
         WRITE(OUT,60)(CHR,I=1,LEN)
      END IF
60    FORMAT(1X,131A1)
      END
