C*************************************************************
      SUBROUTINE BANNER(OUT,PRINTS,PWIDTH,WORDS,FILLEN,FILTYP)
C-------------------------------------------------------------
C Author Geoff Barton
C
C This writes out a line to unit=OUT
C PRINTS is character*1 printer control character
C PWIDTH is INTEGER width of page (max=132)
C WORDS  is CHARACTER*(*) message to be output
C FILLEN is the length of 'filler characters to be applied'
C FILTYP is the type of filler character to be applied (*1)
C
C Example:
C        PRINTS = '1'
C        PWIDTH = 50
C        WORDS  = 'HELLO EVERYONE!'
C        FILLEN = 10
C        FILTYP = '-'
C Output would be:
C        New page, then
C----------       HELLO EVERYONE       ----------
C
C Note:
C        Centering is carried out on the WORDS, which will overwrite
C        any erroneous fillers...
C-------------------------------------------------------------------
C
      INTEGER       OUT,PWIDTH,FILLEN
      CHARACTER*(*) WORDS
      CHARACTER*1   PRINTS,FILTYP
C
      INTEGER       WORDLEN,I,J,START
      CHARACTER*132 LINE
C
      WORDLEN = LEN(WORDS)
      IF(WORDLEN.GE.131.OR.PWIDTH.GT.132)THEN
        CALL AMESS(OUT,2,
     -  'Number of characters supplied to BANNER exceeds page width',
     -  2,'-')
        RETURN
      END IF
      IF(WORDLEN.GE.PWIDTH.OR.FILLEN.GE.PWIDTH)THEN
        CALL AMESS(OUT,2,
     -  'Number of characters requested overflows page width',
     -  2,'-')
        RETURN
      END IF

C
C-----establish start point for writing out WORDS
C
      START = (PWIDTH/2)-(WORDLEN/2)+1
C
      DO 10,I=1,PWIDTH
         LINE(I:I) = ' '
10    CONTINUE
C
      LINE(1:1) = PRINTS
C
      DO 11,I=2,FILLEN+1
         LINE(I:I) = FILTYP
11    CONTINUE
      DO 12,I=PWIDTH-FILLEN,PWIDTH
         LINE(I:I) = FILTYP
12    CONTINUE
C
      J=0
      DO 13,I=START,START+WORDLEN-1
         J=J+1
         LINE(I:I)=WORDS(J:J)
13    CONTINUE
C
      WRITE(OUT,100)(LINE(I:I),I=1,PWIDTH)
100   FORMAT(132A1)
C
      END
C
