C***************************************************************
      SUBROUTINE RECG(LENA,LENB,G3,
     -                  ALOC,BLOC,IBSEQ,IFIN,IDIV)
C---------------------------------------------------------------
C New version which does not operate on a complete MAT array
C This only requires the pair score matrix and the integer
C sequences.
C
C Author: G. J. Barton
C         Copyright 1986 all rights reserved
C
C LENA     length of sequence(s) already aligned
C LENB     length of sequence(s) to be aligned
C G3       length independent gap penalty
C MATCH    maximum match score
C ALOC     start point of best path through LOC(*,*) (row 1)
C BLOC       '    '    '   '    '      '      '      (col 1)
C
C Subroutine RECG: this uses the GAPFAC array to bias the gap
C penalties when aligning each sequence to a block
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'gapmis.blk'
C
C --  passed variables
      integer lena,lenb,aloc,bloc,ibseq,ifin,idiv
      real    g3
C
C --  local variables
      integer I,IP1,J,JP1,K
C
      REAL AMIN,ZERO

      PARAMETER(AMIN=-10000.0,
     -          ZERO=0.0)
C
C
      BMAXJ=AMIN
      DO 20,I=1,LENA
         MROWS(I) =AMIN
         LROWS(I) =LENB
         NEWCOL(I)=ZERO
C
C        use function score to set initial column element
C        eg: score(i,j) gives similarity between acid i,j
C        here we have the multiple alignment case
         OLDCOL(I)=LOOKUP(I,ISEQ(IBSEQ,LENB))
C         write(6,*)'oldcol',i,oldcol(i)
C         OLDCOL(I)=SCORE(IBSEQ,IDIV,IFIN,I,LENB)
20    CONTINUE
C
C
C     loop over length of sequence B
      DO 10,J=(LENB-1),1,-1
         JP1=J+1
C        set max column score to small value
         MAXCOL=AMIN
C        set location of maxcol to sequence A length
         LOCCOL=LENA
C        set value of oldcol(lena)
         NEWCOL(LENA)=LOOKUP(LENA,ISEQ(IBSEQ,J))
C         write(6,*)'newcol',lena,newcol(lena)
C         NEWCOL(LENA)=SCORE(IBSEQ,IDIV,IFIN,LENA,J)
C        loop over length of sequence A
         DO 30,I=(LENA-1),1,-1
            IP1=I+1
C           initialise scalars for maxrow score,
            MAXROW=MROWS(IP1)
C           location of maxrow score
            LOCROW=LROWS(IP1)
C           value of non-insertion case
            ELMP1=OLDCOL(IP1)
C           take into account gap-penalty
            MARROW=MAXROW-GAPFAC(I)
            MACOL =MAXCOL-GAPFAC(I)
C           get current element score using function Score()
            ELM = LOOKUP(I,ISEQ(IBSEQ,J))
C            write(6,*)'elm',elm
C            ELM = SCORE(IBSEQ,IDIV,IFIN,I,J)
C-----------
C           determine best path to ELM
C-----------
C           where ambiguity prefer no insertion to insertion
            IF(ELMP1.GE.MACOL.AND.ELMP1.GE.MARROW)THEN
              NEWCOL(I)=ELM+ELMP1
              LOC(I,J)=IP1
C
C           where ambiguity prefer column to row
            ELSE IF(MACOL.GT.ELMP1.AND.MACOL.GE.MARROW)THEN
              NEWCOL(I)=ELM+MACOL
              LOC(I,J)=LOCCOL
C
C           this should be the only alternative!!
            ELSE IF(MARROW.GT.ELMP1.AND.MARROW.GT.MACOL)THEN
              NEWCOL(I)=ELM+MARROW
              LOC(I,J)=LOCROW+THOU
            ELSE
              WRITE(6,*)'SUMMIT FUNNY HAPPENED'
            END IF
C
C           set up mrow and maxcol for next cycle
            IF(ELMP1.GE.MAXROW)THEN
               MROWS(IP1)=ELMP1
               LROWS(IP1)=JP1
            END IF
            IF(ELMP1.GE.MAXCOL)THEN
               MAXCOL=ELMP1
               LOCCOL =IP1
            END IF
30       CONTINUE
C
C        set up oldcol with the newly calculated values
         DO 40,K=1,LENA
            OLDCOL(K)=NEWCOL(K)
40       CONTINUE
C        set latest value for maxmatch and postion
         IF(OLDCOL(1).GT.BMAXJ)THEN
            BMAXJ=OLDCOL(1)
            BLOC=J
         END IF
10    CONTINUE
C
C     find max value in first column
      AMAXI=AMIN
      DO 50,I=1,LENA
         IF(OLDCOL(I).GT.AMAXI)THEN
           AMAXI=OLDCOL(I)
           ALOC=I
         END IF
50    CONTINUE
C
C     find which max is biggest!
      IF(AMAXI.GE.BMAXJ)THEN
          MATCH=AMAXI
          BLOC=0
      ELSE IF(BMAXJ.GT.AMAXI)THEN
          ALOC=0
          MATCH=BMAXJ
      END IF
C      open(unit=8,file='newloc.bin',status='new',
C     -form='unformatted')
C      write(8)lena,lenb,((loc(i,j),i=1,lena),j=1,lenb)
C      stop
C
      END
C
