#
# Very simple c shell script to run AMPS for a given .seq file
# 1. Run the pairwise mode - no randomizations
# 2. Run ORDER
# 3. Run multiple mode
# 
# 
#
if ($1 == "")then
	echo "Usage: runamps <filename>"
	exit
endif
echo "Cleaning out old AMPS files"
if( -e $1_pair.com) then
	\rm $1_pair.com
endif
if (-e $1_mult.com) then
	\rm $1_mult.com
endif
if (-e $1_ord.com) then
	\rm $1_ord.com
endif
if (-e $1_pair.tree) then
	\rm $1_pair.tree
endif
if (-e $1_pair.tord) then
	\rm $1_pair.tord
endif
if (-e $1_pair.ps) then
	\rm $1_pair.ps
endif
if (-e $1_mult.out) then
	\rm $1_mult.out
endif
if ( -e $1_mult.ps) then
	\rm $1_mult.ps
endif
echo ""
echo "Making AMPS pairwise mode command file: $1_pair.com" 
makeampscom mode pair root $1 matrix /nfs/ind2b/usr/people/gb/IRBM_TAPE/amps/md.mat > $1_pair.com
echo ""
echo "Running AMPS in pairwise mode using file: $1_pair.com" 
multalign < $1_pair.com
echo ""
echo "Making ORDER file using : $1_pair.out"
makeampscom mode order root $1 option 3 > $1_ord.com
echo ""
echo "Running ORDER using file $1_ord.com" 
order < $1_ord.com
echo ""
echo "Making AMPS multiple mode command file: $1_mult.com" 
makeampscom mode mult root $1 matrix /nfs/ind2b/usr/people/gb/IRBM_TAPE/amps/md.mat > $1_mult.com
echo ""
echo "Running AMPS in multiple  mode using file: $1_mult.com" 
multalign < $1_mult.com
echo ""
echo "AMPS alignment complete - $1_mult.blc"
echo ""
echo "Running ALSCRIPT with default parameters"
alscript -q -p < $1_mult.blc > $1_mult.ps
echo ""
echo "ALSCRIPT complete - PostScript in file $1_mult.ps - view with xpsview"
echo ""






