C*******************************************************************
      subroutine wtree(simmat,n,nentry,ident)
C-------------------------------------------------------------------
C This routine outputs an order file and a file containing detailed
C information on which sequences contributed to which clusters at each
C stage of the cluster analysis.
C These files may subsequently be read in by AMULT in order to perform
C a tree based multiple alignment.
C
C Note, there are undoubtedly redundant variables passed in common
C to this routine.  This is the result of splitting a larger program
C-------------------------------------------------------------------
C
C include file of virtually everything
C
      include 'clust.blk'
C
C --------------------------------------------------------------
C

C
      DIVIT = 10.0
      XRANGE = CSCORE(1)-CSCORE(NCLUST)
C
C
C --  Set up a pointer array to the positions of elements to
C     be plotted
      DO 91,I=1,NCTOT(NCLUST)
         POINT(CTOTAL(NCLUST,I)) = I
91    CONTINUE
C
C --  write out the order to the cluster order file
C
      DO 92,I=1,NCTOT(NCLUST)
         write(72,700)ctotal(nclust,i),0.0,0
92    CONTINUE
700   format(1x,i10,f20.2,i10)
        
C
C --  start to write out the cluster details
      DO 93,I=1,NCLUST
C        if we are joining a cluster then write it out
         IF(CPAIRS(1,I).GT.CADD)THEN
            TINDEX = CPAIRS(1,I)-CADD
            write(73,701)nctot(tindex)
            write(73,701)
     -      (point(ctotal(tindex,j)),j=1,nctot(tindex))
         ELSE
            write(73,701)1
            write(73,701)point(cpairs(1,i))
         END IF
C
701      format(1x,20i5)
C
C --     do the second of the pair
         IF(CPAIRS(2,I).GT.CADD)THEN
            TINDEX = CPAIRS(2,I)-CADD
            TOT = 0.0
            write(73,701)nctot(tindex)
            write(73,701)
     -      (point(ctotal(tindex,j)),j=1,nctot(tindex))
          ELSE
            write(73,701)1
            write(73,701)point(cpairs(2,i))
          END IF
C
93    CONTINUE
C
C --
      END
C
