C*******************************************************************
      program pattern
C------------------------------------------------------------------
C
C Author: Geoff Barton 1989
C
C Program to read the output of a pattern scan - with alignments
C and format to give the pattern at the top and only those regions
C that match to the pattern underneath.
C
C This program reads the following format file:
C
C #Pattern    !start of pattern description
C Nelm, Nchar !Number of elements in pattern/number of characters/element(10,9)
C E1          !Pattern element 1  (eg. AAAGGGCCC) (80a1)
C F1          !Flexible Gap range 1 (eg. 0,3)
C  "
C  "
C etc
C EN          !Nth pattern element - this ends pattern description
C #Details    !Details of the first recorded pattern match
C ID          !Protein Identifier 10 chars 
C Title       !Protein title - 80 chars
C Len         !Protein Length - 80 chars max
C An,Pn       !Sequence No, Pattern alignement Number
C Score       !Real number  - max 80 chars
C #Sequence   !Start of sequence identifier
C one letter code sequence 80a1 format
C #Match      !Description of the match follows
C 1,Pos       !N,Pos - N is the pattern element, Pos is the sequence element
C 2,Pos       !which it is aligned.  If the pattern overhangs, then N is 0.
C N,Pos
C #Details    !Start of next pattern alignment, or end of file
C
C
C This format file is output by MSCAN in response to the 
C print_horizontal/pattern=fname command
C
C Note:  The An,Pn refer to the An(th) sequence aligned to the pattern, 
C        and the Pn(th) alignment of the pattern to this sequence - thus
C        1,1 refers to the top scoring pattern match with sequence 1,
C        1,2 the second best pattern match to seq 1 etc.
C Put Under RCS control G. J. B. 4/August 1995
C
C $Id: pattern.f,v 1.3 1995/09/04 17:16:05 gjb Exp gjb $
C $Log: pattern.f,v $
C Revision 1.3  1995/09/04 17:16:05  gjb
C Attempted to add code to lose lines between <x:y and next
C pattern block.  This failed because the program is buggy in
C ways I cannot discern.  Gave up and wrote a perl script
C to parse the output...
C
C Revision 1.2  1995/09/04 13:41:02  gjb
C Added wdets2 routine.  This writes header information
C to the block file output so that the file can be used
C directly by AMPS as a pattern file.
C
C Revision 1.1  1995/09/04 13:28:24  gjb
C Initial revision
C
C
C--------------------------------------------------------------------------
      include 'pattern.blk'
C
      integer j,i,ios,outlen,outopt
C
      error = .false.
      bbar = bhor
      outopt = 3
C
      do 5,i=1,maxseq
         ind(i) = i
5     continue
C
C --
      call amess(imess,1,'Program    P A T T E R N',1,'-')
      call amess(imess,1,
     -  'Processes FSCAN print_horizontal/pattern output',1,' ')
      call amess(imess,0,'Author:  Geoff Barton',1,' ')
      write(imess,6001)maxdim
6001  format(1x,'Maximum Pattern Length: ',i8)
      write(imess,6002)maxseq
6002  format(1x,'Maximum Pattern Hits + Pattern to Display: ',i8)
      call qmess(imess,icom,1,'Enter Pattern file: ',line)
      open(unit=iin,file=line,status='old',iostat=ios)
      if(ios.ne.0)then
         write(ierr,*)'Error opening file: ',line
         stop
      end if
      call qmess(imess,icom,1,'Enter Output file: ',line)
      open(unit=iout,file=line,status='new',iostat=ios)
      if(ios.ne.0)then
         write(ierr,*)'Error opening file: ',line
         stop
      end if
      call qmess(imess,icom,1,
     -'Enter page width for horizontal output (>50, Def:132): ',line)
      call intcom(line,outlen,error)
      if(outlen.lt.50.or.error)then
         outlen=132
      end if
      write(imess,90)outlen
90    format(1x,'Output width: ',i7)
C
C --get pattern description from iin
      call amess(imess,0,'Reading Pattern Description',0,' ')
      call getpat
      if(error)then
         call amess(ierr,1,'Error reading pattern',1,' ')
         stop
      end if
C
C --get details of each alignment and output to screen
      call amess(imess,0,'Reading Pattern Alignment',0,' ')
      call getdet
      if(error)then
         call amess(ierr,1,'Error reading alignment details',1,' ')
         stop
      end if
      call wdets(imess)
C
C --sort the results??
      call qmess(imess,icom,1,'Sort the scores? [Y] ',line)
      call cucase(line)
      if(.not.(index(line,'N').gt.0))then
C      write(ierr,*)'score array before sort ',(score(i),i=1,nseq)
C         call sortbs(
C     -        score(nchar+1),nseq-nchar+1,sorted(nchar+1),ind(nchar+1))
C --   substitute NR subroutine 27/May/91
       call indexx(nseq-nchar+1,score(nchar+1),ind(nchar+1))
C      write(ierr,*)'sorted array after sort ',(sorted(i),i=1,nseq)
C --     correct the offset in ind and (un-sort the sorted scores)
         do 20,i=nchar+1,nseq
            ind(i) = ind(i) + nchar
20       continue
C         do 30,j=1,nseq
C            score(ind(j))=sorted(j)
C30       continue
         call wdets(iout) 
      end if
C
C --  Output options:  1 = full output - only useful to look at.
C --                   2 = just vertical format - 
C --                       can be used for an alignment scan.
C --                   3 = just pattern
C --                       can be used for a pattern scan.
      call qmess(imess,icom,1,'Output Option 1, 2 or 3? [3] ',line)
      call intcom(line,outopt,error)
      if(error)then
         outopt = 3
      end if

C
C --  get each aligned sequence in turn and store in alig
      call amess(imess,0,'Formatting Alignments',0,' ')
      call getal
C
C --  just write out the alignments in simple format for now
      call amess(imess,0,'Adding Flexible Gap Details',0,' ')
      call addran
      call amess(imess,0,'Writing Vertical Format Alignment',0,' ')
C
C --  Write out the identifiers first so that we can read this as a blocfile
      if(outopt .eq. 2 .or. outopt .eq. 3)then
         call wdets2(iout)
      end if
C
C --  if we just want to output the pattern, then remove non pattern positions
C --  in fact this routine just sets the lines to blanks
C --  the output printing then does not print blank lines
C Rather than bugger around with this - just write a little perl script
C to reformat the output.
C      if(outopt .eq. 3) then
C         call delpos
C      end if
C      write(6,*)'Back from delpos'
C
      do 11,j=-30,0
         write(iout,101)(alig(j,ind(i)),i=1,nseq+13)
11    continue
C      write(6,*)'Written header'
      write(iout,1011)
1011  format(1x,'*iteration 1')
      do 10,j=1,cpos
         write(iout,101)(alig(j,ind(i)),i=1,nseq+13)
10    continue
      write(iout,1012)
C      write(6,*)'Written seqs'
1012  format(1x,'*')
      do 12,j=cpos+1,cpos+6
         write(iout,101)(alig(j,ind(i)),i=1,nseq+13)
12    continue
C      write(6,*)'Written tail'
C
C --  this format statement is critical - must cope with max expected seqs.
101   format(1x,9000a1)
C
      if(outopt .ne. 3)then
         call amess(imess,0,'Writing Horizontal Format Alignment',0,' ')
         call pretty(outlen)
         write(6,*)'Written pretty'
      end if
C
      stop
C
      end
C
C******************************************************************
      subroutine getpat
C------------------------------------------------------------------
C Author: Geoff Barton (1989)
C
C Reads the pattern section of the file starting with #Pattern
C Does rudimentary error checking
C
C-----------------------------------------------------------------
C
      include 'pattern.blk'
C
      integer i,k,j
C
100   format(a80)
101   format(80a1)
C
      error = .false.
      rewind(iin)
      call amess(imess,0,'---Initializing alig',0,' ')
      do 222,i=1,maxseq
         do 223,j=-38,maxdim+6
            alig(j,i)=' '
223      continue
222   continue
6000  format(1x,2i7)
C      call initc(alig,(maxdim+6+38+1)*maxseq,' ')
      call amess(imess,0,'---Initializing id',0,' ')
      call initc(id,maxseq,' ')
      call amess(imess,0,'---Done',0,' ')
C     
1     continue
      read(iin,100,end = 1000)line
      if(line(1:2).eq.'#P')then
        read(iin,100)line
C --    decode the number of elements and number of characters/element
        call iiread(line,nelm,nchar,',',ierr,error)
        if(error)return
C --    read the pattern exploded to max allowed length and record
C       pointers to the element positions in the alig array
        cpos = 1
        do 10, i=1,nelm
           read(iin,101)(alig(cpos,k),k=1,nchar)
           ploc(i) = cpos
           if(i.lt.nelm)then
              read(iin,100)line
              call iiread(line,gapmin(i),gapmax(i),',',ierr,error)
              if(error)return
              cpos = cpos + gapmax(i) + 1
              if(cpos.gt.maxdim)then
                 call amess(ierr,1,'Error: Pattern too long',1,' ')
                 return
              end if
            end if
10      continue
      else
        goto 1
      end if
C
      return
C
1000  continue
      call amess
     -(ierr,1,'Error: can''t find #Pattern identifier',1,' ')
C
      end
C
C*******************************************************************
      subroutine getdet
C-------------------------------------------------------------------
C Author: Geoff Barton (1989)
C
C Gather all the information following the #Details location in 
C the pattern file
C
C ie ID,Title,Len,An,Pn,Score
C--------------------------------------------------------------------
      include 'pattern.blk'
C
      rewind(iin)
      error = .false.
      nseq = nchar
C
100   format(a80)
101   format(a)
C
1     continue
      read(iin,100,end = 1000)line
      if(line(1:2).eq.'#D')then
         nseq = nseq + 1
C      write(ierr,*)nseq
         if(nseq.gt.maxseq)then
            write(ierr,*)'Max number of sequences exceeded: ',maxseq
            return
         end if
         read(iin,101)id(nseq)
C       write(ierr,*)id(nseq)
         call setid(nseq)
         read(iin,100)title(nseq)
C       write(ierr,*)title(nseq)
         read(iin,100)line
         call intcom(line,lens(nseq),error)
C       write(ierr,*)lens(nseq)
         if(error)then
            write(ierr,*)'Error reading length: ',nseq,lens(nseq)
            return
         end if
         read(iin,100)line
         call iiread(line,an(nseq),pn(nseq),',',ierr,error)
C       write(ierr,*)an(nseq),pn(nseq)
         call setan(nseq)
         if(error)then
            write(ierr,*)'Error reading an,pn ',nseq,an(nseq),pn(nseq)
            return
         end if
         read(iin,100)line
         call reacom(line,score(nseq),error)
C       write(ierr,*)score(nseq)
         call setsco(nseq)
C       write(ierr,*)
         if(error)then
            write(ierr,*)'Error reading score ',nseq,score(nseq)
            return
         end if
      end if
      goto 1
C
1000  continue
      return
C
      end
C
C******************************************************************
      subroutine wdets(io)
C------------------------------------------------------------------
C Author: Geoff Barton 1989
C
C Write out the details of this alignment file to screen
C------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,io
C
C      write(imess,101)
C101   format(1x,'  Score',1x,'        ID','  Seq',' Alig','Title')
      do 10,i=nchar+1,nseq
         write(io,100)
     -   score(ind(i)),id(ind(i)),lens(ind(i)),
     -   an(ind(i)),pn(ind(i)),title(ind(i))
10    continue
C
100   format(1x,f7.2,1x,a10,i5,i5,i5,1x,a44)
C
      end
C
C******************************************************************
      subroutine wdets2(io)
C------------------------------------------------------------------
C Author: Geoff Barton 4 August 1995
C Modified form of wdets
C
C Write out the details of this alignment file to file
C------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,io
C
C      write(imess,101)
C101   format(1x,'  Score',1x,'        ID','  Seq',' Alig','Title')
      do 10,i=nchar+1,nseq
         write(io,100)
     -   id(ind(i)),score(ind(i)),lens(ind(i)),
     -   an(ind(i)),pn(ind(i)),title(ind(i))
10    continue
C
100   format(1x,a10,5x,f7.2,i5,i5,i5,1x,a44)
C
      end
C
C*******************************************************************
      subroutine getal
C-------------------------------------------------------------------
C Author: Geoff Barton (1989)
C
C Read each #Sequence and the #Match records in turn and store the 
C alignment in alig
C
C-------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,k,l
C
100   format(a80)
101   format(80a1)
C
      rewind(iin)
      i = nchar
C
C --read the sequences in in order
1     continue
      read(iin,100,end=1000)line
      if(line(1:2).eq.'#S')then
         i = i + 1
         read(iin,101)(seq(k),k=1,lens(i))
C      write(ierr,101)(seq(k),k=1,lens(i))
         read(iin,100)line
         do 10,l=1,nelm
            read(iin,100)line
C
C	    write(ierr,111)nelm,l
C111         format(1x,2i5)
C            write(ierr,100)line
C
            call iiread(line,pp,ss(l),',',ierr,error)
10       continue
C         write(ierr,'(a)')'Calling sets'
         call sets(i,ss(1),ss(nelm))
C         write(ierr,'(a)')'Calling alseq'
         call alseq(i)
      end if
C
      goto 1
C
1000  continue
C
      end
C
C******************************************************************
      subroutine alseq(i)
C------------------------------------------------------------------
C Author: Geoff Barton (1989)
C
C i is the i'th sequence to be aligned to the pattern
C the pointer array ind(i) points to the sequences is score order
C
C Take the sequence read into seq(lens(i)) and store it in aligned form
C in the alig(maxdim,maxseq) array by using the ss(nelm,i) and
C pn pointers to which residues align to which positions in the pattern
C
C--------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,j,k,icurr
C
      do 10,j=1,nelm
C        loop over number of elements in pattern
         if(ss(j).gt.0)then
C           if pattern element is aligned with seq element, get pointer to alig
            icurr = ploc(j)
C           store seq in alig
            alig(icurr,i) = seq(ss(j))
            if(j.lt.nelm)then
C              copy seq positions into alig after current element
               do 20,k=ss(j)+1,ss(j+1)-1
                  icurr = icurr + 1
                  alig(icurr,i) = seq(k)
20             continue
            end if
         end if
10    continue
C
      end
C
C*********************************************************************
      subroutine setid(i)
C---------------------------------------------------------------------
C copy ID into alig array
C---------------------------------------------------------------------
      include 'pattern.blk'
C
      integer k,i,j
C
C set k=1 to loose the > from identifier
      k = 1
C
      alig(-38,i) = '_'
C      write(ierr,*)bbar
C      write(ierr,*)id(i)
C
      do 10,j= -37, 9-37
         k = k + 1
         alig(j,i) = id(i)(k:k)
10    continue
C
      end
C
C****************************************************************
      subroutine setan(i)
C----------------------------------------------------------------
C copy an and pn into alig array
C----------------------------------------------------------------
      include 'pattern.blk'
C
      character*5 inchar,anc,pnc
      integer i,j,k
C
      anc = inchar(an(i))
      pnc = inchar(pn(i))
C      write(ierr,*)anc
C      write(ierr,*)pnc
C
      alig(-27,i) = '_'
      alig(-21,i) = '_'
      k = 0
      do 10,j=-26,4-26
         k = k + 1
         alig(j,i) = anc(k:k)
10    continue
C
      k = 0
      do 20, j = -20, 4-20
         k = k + 1
         alig(j,i) = pnc(k:k)
20    continue
C
      end
C
C*******************************************************************
      subroutine setsco(i)
C-------------------------------------------------------------------
C put score into alig array
C------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,j,k
      character*7 rechar,cscore
C
      cscore = rechar(score(i),2)
C      write(ierr,*)cscore
C
      alig(-15,i) = '_'
      alig(-7,i) = '_'
C
      k = 0
      do 10,j = -14,6-14
         k = k + 1
         alig(j,i) = cscore(k:k)
10    continue
C
      end 
C
C*********************************************************************
      subroutine sets(i,start,end)
C---------------------------------------------------------------------
C put start and end residue numbers into alig
C---------------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,start,end,k,j
C
      character*5 inchar,sschar,echar
C
      sschar = inchar(start)
      echar = inchar(end)
C
C      write(ierr,*)'************************!!!! sschar',sschar
C      write(ierr,*)'!!!!!!!!!!!!!!!!!!!!!!!!!!!! echar ',echar
      k = 0
      do 10,j = -6,4-6
         k = k + 1
         alig(j,i) = sschar(k:k)
10    continue
C
      k = 0
      do 20, j = cpos+1,cpos+5
         k = k + 1
         alig(j,i) = echar(k:k)
20    continue
C
      end
C
C***************************************************************
      subroutine addran
C---------------------------------------------------------------
C Add the < gmin:gmax values to the alig array after the last
C aligned sequence
C
C---------------------------------------------------------------
      include 'pattern.blk'
C
      integer i,j,k,endfin
      character*5 inchar,gmin,gmax,gcat*15,justl
C
      do 10,i=1,nelm
         if(gapmax(i).eq.0)goto 10
         gmin = justl(inchar(gapmin(i)))
         gmax = justl(inchar(gapmax(i)))
         gcat = 
     -   '<'//gmin(:endfin(gmin))//':'//gmax(:endfin(gmax))
         k = 0
         do 20,j=nseq+2,nseq+2+endfin(gcat)
            k = k + 1
            alig(ploc(i),j)=gcat(k:k)
20       continue
10    continue
C
C --set indexes for the entries after nseq
      do 40,i=nseq+1,nseq+1+15
         ind(i) = i
40    continue
C
C
      end
C
C*****************************************************************
      SUBROUTINE pretty(outlen)
C------------------------------------------------------------------
C WRITES SEQUENCE AND QUERY TO IO, OUTLEN PER LINE
C-----------------------------------------------------------------
      include 'pattern.blk'
C
      integer STCHN,LINCR,LSTART,LFIN,LEN,NLIN,I,J
      integer OUTLEN,K

C set _ character to | character for horizontal output
      do 222, i=1,nseq+13
         if(alig(-38,i).eq.'_')alig(-38,i)='|'
         if(alig(-27,i).eq.'_')alig(-27,i)='|'
         if(alig(-21,i).eq.'_')alig(-21,i)='|'
         if(alig(-15,i).eq.'_')alig(-15,i)='|'
         if(alig(-7,i).eq.'_')alig(-7,i)='|'
222   continue

      STCHN =1
      LINCR =OUTLEN
      LSTART=STCHN
      LFIN  =STCHN+LINCR-1
      LEN   =cpos + 6
      NLIN  =INT(((LEN-STCHN)+1)/LINCR)+1
C

      DO 10,J=1,NLIN
         IF(LFIN.GT.LEN)LFIN=LEN
         DO 20,K=1,nseq+13
           WRITE(iout,61)
     -   (alig(i,ind(k)),i=-38,0),(alig(I,ind(K)),I=LSTART,LFIN)
20       CONTINUE
         IF(LFIN-STCHN.EQ.LEN-1)RETURN
         LSTART=LSTART+LINCR
         LFIN=LFIN+LINCR
         WRITE(IOut,100)
10    CONTINUE
61    FORMAT(1X,9000a1)
100   FORMAT(1X,//)
      END
C
C***************************************************************
      subroutine delpos
C---------------------------------------------------------------
C set the yth  lines between  a <x:y statement to blanks
C
C
C---------------------------------------------------------------
      include 'pattern.blk'
C
C
      integer j, i, k,l
      character*20  temp
      logical found
      integer gmax

      k = 0

      call initc(temp,20,' ')

      write(6,*)'CPOS', cpos

      do 10, j=1,cpos
         if(alig(j,ind(nseq+2)) .eq. '<')then
C           search for colon
            write(6,*)'found < now looking for :'
            found = .false.
            l = 0
            do 40,k=nseq+3,nseq+13
               if(found)then
                  l = l + 1
                  temp(l:l) = alig(j,ind(k))
               end if
               if(alig(j,ind(k)) .eq. ':')then
                  found = .true.
               end if
 40         continue
            if(found)then 
               write(6,*)'Found : now converting'
               call intcom(temp,gmax,error)
               write(6,*)'gmax:',gmax
               do 20, i= j+1, j+gmax
                  write(6,*)'J:',j
                  do 30, l=1,nseq+13
                     write(6,*)'    L:',l,' ind(l):',ind(l)
                     alig(i,ind(l)) = ' '
 30               continue
 20            continue
            end if
          end if
 10    continue
       write(6,*)'Leaving delpos'
       return 

       end
C
