#include <stdio.h>
#include <ctype.h>

/************************************************************************
   getsec():
   read from file until EOF, or * encountered all 
   characters leave the case intact.
   Store in seq[] starting from position 1.  Set position 0 to ' '

   Returned value is the TOTAL character array length.  ie.
   sequence length + 1 + 1

   This routine is meant for reading K & S definitions, 
   or similar that are presented in the same format at a PIR sequence
   entry.  Note that SPACES are NOT CONSIDERED as valid entries.
------------------------------------------------------------------------*/
int getsec(file,seq,maxlen)

char seq[];
int maxlen;
FILE *file;
{
    char c;
    int i;

    i = 1;
    seq[0] = ' ';

    while((c=fgetc(file)) != '*'){
	if((i < maxlen-1) && !isspace(c)){
	    seq[i++] = c;
	}
	else if( i == maxlen-1 ){
	    fprintf(stderr,"Structure Truncated to: %d\n",maxlen);
	    seq[i++] = '\0';
	    return i;
	}
	else if( c == EOF)
	    return 0;
    }
    seq[i++] = '\0';
    return i;
}
