#include <stdio.h>
#include <float.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "gjutil.h"
/*#include "oc.h"*/
#define MAX_ID_LEN 50
#define MATRIX_FILE "/home/gjb/data/md.mat"

/***********************************************************************

makeampscom:  makes an AMPS .com file with standard defaults
              root is used to specify root.seq, root.tord and root.tree files
                                      and root.blc outputfile

Add option -s to generate a command file that uses just the .ord file
            (single order alignment).

3/March 1994:  Add options...

----------------------------------------------------------------------*/

main(int argc,char *argv[])
{
  extern FILE *std_in,*std_out,*std_err;

  char *root,*mode,*mfile;
  int single;
  int order;
  int nran;
  float pen;
  int constant;
  int i;
  int option;

  single = 0;
  nran = 0;
  pen = 8.0;
  constant = 8;
  mfile = NULL;
  order = 0;
  option = 3;

  GJinitfile();
  
  if(argc < 2) {
    GJerror("Usage: makeampscom [options]\n");
    exit(-1);
  }
  i = 1;
  while(i<argc){
    if(strcmp(argv[i],"mode") == 0){
      ++i;
      mode = GJstrdup(argv[i]);
    }else if(strcmp(argv[i],"root") == 0){
      ++i;
      root = GJstrdup(argv[i]);
    }else if(strcmp(argv[i],"matrix") == 0){
      ++i;
      mfile = GJstrdup(argv[i]);
    }else if(strcmp(argv[i],"ran") == 0){
      ++i;
      nran = (int) atol(argv[i]);
    }else if(strcmp(argv[i],"pen") == 0){
      ++i;
      pen = (float) atof(argv[i]);
    }else if(strcmp(argv[i],"option") == 0){
      ++i;
      option = (int) atol(argv[i]);
    }else if(strcmp(argv[i],"const") == 0){
      ++i;
      constant = (int) atol(argv[i]);
    }else if(strcmp(argv[i],"single") == 0){
      single = 1;
    }else{
      GJerror("Unrecognised Option\n");
      exit(-1);
    }
    ++i;
  }
  if(strcmp(mode,"order") == 0){
      order = 1;
  }
  if(mfile == NULL) mfile = GJstrdup(MATRIX_FILE);

  if(order != 1){
    if(strcmp(mode,"pair")==0){
      fprintf(std_out,"output_file=%s_%s.out\n",root,mode);
      fprintf(std_out,"mode=pairwise\n");      
    }else{
      fprintf(std_out,"output_file=%s_%s.blc\n",root,mode);
      fprintf(std_out,"mode=multiple\n");
    }
    fprintf(std_out,"matrix_file=%s\n",mfile);
    fprintf(std_out,"constant=%d\n",constant);
    fprintf(std_out,"gap_penalty=%f\n",pen);
    fprintf(std_out,"seq_file=%s.seq\n",root);
  }else{
    fprintf(std_out,"%s_pair.out\n",root);
    fprintf(std_out,"N\n\nN\n%d\nN\nY\nY\n",option);
    fprintf(std_out,"%s_pair.tord\n",root);
    fprintf(std_out,"%s_pair.tree\n",root);
    fprintf(std_out,"%s_pair.ps\n",root);
    fprintf(std_out,"Normalised Alignment Score\n");
    fprintf(std_out,"%s Pairwise Data\n",root);
    fprintf(std_out,"12\n0.5\n0 1000 10\nN\n",root);
    exit(0);
  }

  if(strcmp(mode,"pair") == 0){
    if(nran > 0){
      fprintf(std_out,"pairwise_random=%d,%d,1\n",nran,nran);
    }
  }else{
    fprintf(std_out,"order_file=%s_pair.tord\n",root);
    if(!single){
      fprintf(std_out,"tree_file=%s_pair.tree\n",root);
    }
    fprintf(std_out,"print_vertical=\n");
    fprintf(std_out,"print_horizontal=\n");
  }
  exit(0);
}







