C**************************************************************
      SUBROUTINE MLOOK3(IBSEQ,IFIN,IDIV,KPOS)
C--------------------------------------------------------------
C Subroutine to make a look up table for subsequent reference by
C RECALL
C
C This version uses the amino acid probability data to construct
C a weight matrix:  see Dodd and Egan J Mol Biol 1987 194 557.
C
C Author:  G. J. Barton
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'dayhof.blk'
      include 'param2.blk'
      include 'probas.blk'
C
      integer ibseq,ifin,idiv,kpos
C --
      INTEGER I,J,K
      REAL TEMP,PR
      temp =0.0
      pr = 0.0
C
C --  loop over each amino acid type
C     do not consider the possibility of gaps (g.j.b. 26/7/88)
      DO 10,I=1,23
C
C --     loop over the aligned positions
         DO 20,J=1,KPOS
C
C --        calculate frequency at this point
            TEMP=0.0
            DO 30,K=1,IFIN
               IF(K.EQ.IBSEQ)THEN
                 GOTO 30
               ELSE IF(ISEQ(K,J).EQ.I)THEN
                 TEMP = TEMP +1.0
               END IF
30          CONTINUE
C
C --        calculate weight and store in the lookup table
            IF(TEMP.LT.1.0)THEN
C             zero occurences follow Dodd and Egan here
              PR = 1.0/((IDIV+1)*APROBS(I))
C           if PR is gt 1 then set it to 1
               IF(PR.GT.1.0)THEN
                 PR = 1.0
               END IF
            ELSE
              PR = TEMP/(IDIV*APROBS(I))
            END IF
C --        take log and multiply by 100
            LOOKUP(J,I)=LOG(PR)*100.0
C           write(6,*)pr,lookup(j,i)
20       CONTINUE
10    CONTINUE
C
      END
C

