C************************************************************
      PROGRAM DAYTB
C------------------------------------------------------------
C Program to convert a PIR sequence file to AMPS BLOCK file
C format
C
C Author:  G. J. Barton
C------------------------------------------------------------
C
      INTEGER MAXDIM,LEN,I,IOS
      PARAMETER (MAXDIM=8000)
C
      CHARACTER*1 SEQ(MAXDIM)
      CHARACTER*80 LINE,IDENT*20,TITLE*80
C
      LOGICAL EOF,ERROR
C
      EOF=.FALSE.
      ERROR=.FALSE.
      call amess(6,1,'D A Y B',1,'-')
      call amess(6,1,
     -'Convert PIR Sequence file to AMPS Block File',1,' ')
      write(6,600) MAXDIM
600   format(1x,'Maximum sequence length allowed:',i6,/)
C
C
1     CONTINUE
      CALL QMESS(6,5,1,'Enter PIR Sequence Filename: ',line)
      OPEN(UNIT=1,FILE=LINE,STATUS='OLD',IOSTAT=IOS)
      IF(IOS.NE.0)THEN
        CALL AMESS(6,1,'ERROR OPENING FILE',1,'E')
        GOTO 1
      END IF
C
C --  get the seq
      CALL FSEQMF(1,6,EOF,ERROR,.TRUE.,' ',SEQ,MAXDIM,LEN,
     -IDENT,TITLE)
C
C --
      IF(ERROR.OR.EOF)THEN
        CALL AMESS(6,1,'ERROR READING SEQUENCE',1,'E')
        GOTO 1
      END IF
C
C --  write the seq out
      CALL QMESS(6,5,1,
     -'Enter Output Filename (Block file): ',line)
      OPEN(UNIT=2,FILE=LINE,STATUS='NEW',iostat=ios)
      if(ios.ne.0)then
        call amess(6,1,'Error opening file',1,'e')
        goto 1
      end if
      WRITE(2,20)IDENT,TITLE
      WRITE(2,21)(SEQ(I),I=1,LEN)
      WRITE(2,21)'*'
C
C --  GOTO 1
C
20    FORMAT(A20,1X,A80/'*ITERATION 1')
21    FORMAT(A1)
      END


