C**********************************************************************
      subroutine wrclus(simmat,n,nentry,ident)
C----------------------------------------------------------------------
C Author: Geoff Barton 5/10/1988
C
C Subroutine prompts the user for a cutoff value.  All clusters .ge. that
C value are then output in prolog terms
C
C eg.
C pclust([ident1,ident2,ident3.....],cutoff).
C
C The list represents the identifiers of the members of the cluster, cutoff is
C included to allow various sub-groups of the data to be examined in Prolog.
C
C-----------------------------------------------------------------------
      include 'clust.blk'
C
C --pointer to current cluster, cutoff value
      integer icp,jj,ijk
      real ccut
      logical error
C
C --
C      do 33,i = 1,nclust
C      write(0,*)cscore(i),(ctotal(i,ii),ii=1,nctot(i))
C33    continue
C
C --get the cutoff value
      call qmess(6,5,1,'Enter cutoff for clusters: ',line)
      call reacom(line,ccut,error)
C
C --  loop over the number of clusters recorded in ctotal array
      do 10, i = 1,nclust
         icp = i
         if(cscore(icp).ge.ccut)then
C --        cutoff satisfied by this cluster
C --        so loop over clusters remaining to identify poss overlap
            do 20, j = (i+1),nclust
C --           loop over members of jth cluster 
               do 30, jj = 1, nctot(j)
C --              loop over members of current cluster
                  do 40, ii = 1, nctot(icp)
                     if(ctotal(icp,ii).eq.ctotal(j,jj))then
C --                    the jth cluster is common to icp-th one
                        if(cscore(j).ge.ccut)then
C --                       jth cluster is also above cutoff
                           if(nctot(j).gt.nctot(icp))then
C --                          jth cluster is bigger
                              cscore(icp) = minset
                              icp = j
                           else
                              cscore(j) = minset
                           end if
C --                       goto next jth cluster
                           goto 20
                        end if
                     end if
40                continue
30             continue
20          continue
C --        have found the largest consistent cluster, now remove other
C           clusters that have common members
            do 50,ijk = 1, nclust
               if(ijk.ne.icp)then
                  do 60,ii=1,nctot(icp)
                     do 70,jj=1,nctot(ijk)
                        if(ctotal(icp,ii).eq.ctotal(ijk,jj))then
                           cscore(ijk) = minset
                           goto 50
                        end if
70                   continue
60                continue
               end if
50          continue
            call wc3(simmat,n,nentry,ident,ccut,icp)
            cscore(icp) = minset
         end if
10    continue
C
      end
C
C*******************************************************************
      subroutine wc3(simmat,n,nentry,ident,ccut,icp)
C-------------------------------------------------------------------
C Author: Geoff Barton 1988
C
C Write out the identifiers of members of cluster icp in prolog form
C
C-------------------------------------------------------------------
      include 'clust.blk'
C
      integer icp,ijk
      real ccut
C
      write(7,76)'pclust(['
      do 33,ijk=1,nctot(icp)-1
         write(7,77)
     -        ident(ctotal(icp,ijk))(:endfin(ident(ctotal(icp,ijk))))
33    continue
      ijk = nctot(icp)
      write(7,78)
     -        ident(ctotal(icp,ijk))(:endfin(ident(ctotal(icp,ijk)))),
     -        ccut,cscore(icp)
C
76    format(a)
77    format('''',a,''',')
78    format('''',a,'''],',f7.2,',',f7.2').')
C
      end
C
         

