C***************************************************************
      SUBROUTINE ALIGN(M,N,LOCA,LOCB,KPOS)
C---------------------------------------------------------------
C This version specifically written for program BMULT, but
C could quite easily be used elsewhere...
C
C      ALIGNS THE SEQUENCES jaseq,jbseq
C      USING THE MATRIX LOC(M,N) TO INDICATE THE PATH
C      OF THE BEST MATCH. SEE SUBROUTINE RECURS FOR
C      EXP.OF LOC(M,N)
C      SEE SUBRTN. LOCATE FOR EXP. OF LOCA,LOCB
C      jaout,jbout STORE THE ALIGNED SEQUENCES
C
C Author: G. J. Barton  (1984)
C
C Note:  THOU parameter must exceed the max sequence length
C---------------------------------------------------------------
      include 'params.blk'
      include 'intseq.blk'
      include 'matloc.blk'
C
      integer m,n,loca,locb,kpos
C
      INTEGER   IOLD,JOLD,INEXT,JNEXT,
     -          IDIFF,JDIFF,IJ,IVAL
      iold = 0
      jold = 0
      inext = 0
      jnext = 0
      idiff = 0
      jdiff = 0
      ij = 0
      ival = 0
C---------------------------------------------------------------
C      IOLD,JOLD = THE COORDS OF THE LAST ARRAY ELEMENT OF LOC
C      INEXT,JNEXT = THE COORDS OF THE NEXT/CURRENT ELEMNT LOC
C---------------------------------------------------------------
      IOLD=0
      JOLD=0
      KPOS=0
C---------------------------------------------------------------
C      LOCATE FIRST ELEMENT OF MAX MATCH USING LOCA,LOCB
C---------------------------------------------------------------
      IF(LOCA.EQ.0)THEN
         INEXT=1
         JNEXT=LOCB
      ELSE
         INEXT=LOCA
         JNEXT=1
      END IF
C---------------------------------------------------------------
C      CALCULATE DIFFERENCE IN I AND J INDICIES WHEN PROCEEDING
C      FROM IOLD,JOLD TO INEXT,JNEXT
C---------------------------------------------------------------
1000      IDIFF=INEXT-IOLD
      JDIFF=JNEXT-JOLD
C---------------------------------------------------------------
C      A VALUE OF IDIFF .GT.1 INDICATES AN INSERT IN jaseq
C      A VALUE OF JDIFF .GT.1 INDICATES AN INSERT IN jbseq
C      IF IDIFF=JDIFF=1 THEN THER IS NO INSERTION
C      KPOS IS THE CURRENT INDEX IN jaout(KPOS),jbout
C---------------------------------------------------------------
      IF(IDIFF.GT.1)THEN
         DO 200,IJ=(IOLD+1),INEXT
            KPOS=KPOS+1
            jaout(KPOS)=jaseq(IJ)
            jbout(KPOS)=IGAP
            IF(IJ.EQ.INEXT)THEN
             jbout(KPOS)=jbseq(JNEXT)
            END IF
200         CONTINUE
      ELSE IF(JDIFF.GT.1)THEN
         DO 300,IJ=(JOLD+1),JNEXT
            KPOS=KPOS+1
            jbout(KPOS)=jbseq(IJ)
            jaout(KPOS)=IGAP
            IF(IJ.EQ.JNEXT)THEN
             jaout(KPOS)=jaseq(INEXT)
            END IF
300         CONTINUE
      ELSE
         KPOS=KPOS+1
         jaout(KPOS)=jaseq(INEXT)
         jbout(KPOS)=jbseq(JNEXT)
      END IF
C---------------------------------------------------------------
C      UPDATE IOLD,JOLD
C      THEN INTERROGATE LOC(IOLD,JOLD) TO DISCOVER THE VALUES
C      OF NEXTI,NEXTJ
C      A VALUE OF LOC( , ) GT THOU INDICATES AN INSERTION IN
C      jbseq
C      THIS IS JUST A CONVENIENT WAY OF CODING THE TYPE OF
C      INSERTION jaseq OR jbseq
C      SEE SUBROUTINE RECURS FOR DETAILS OF LOC CREATION
C--------------------------------------------------------------
      IOLD=INEXT
      JOLD=JNEXT
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE  IE IOLD=M-1,OR JOLD=N-1
C---------------------------------------------------------------
      IF(IOLD.EQ.(M).OR.JOLD.EQ.(N))THEN
      ELSE
          IVAL=LOC(IOLD,JOLD)
          IF(IVAL.GT.THOU)THEN
             INEXT=IOLD+1
             JNEXT=IVAL-THOU
          ELSE
             INEXT=IVAL
             JNEXT=JOLD+1
          END IF
          GO TO 1000
      END IF
C---------------------------------------------------------------
C      TEST FOR END OF SEQUENCE AND INSERT BLANKS IN THE
C      APPROPRIATE OUT(A/B) ARRAY
C---------------------------------------------------------------
      IF((IOLD.EQ.M).AND.(JOLD.EQ.N))THEN
         jaout(KPOS)=jaseq(M)
         jbout(KPOS)=jbseq(N)
         RETURN
      ELSE IF(IOLD.EQ.M)THEN
         DO 400,IJ=JNEXT+1,N
            KPOS=KPOS+1
            jaout(KPOS)=IGAP
            jbout(KPOS)=jbseq(IJ)
400         CONTINUE
         RETURN
      ELSE IF(JOLD.EQ.N)THEN
         DO 500,IJ=INEXT+1,M
            KPOS=KPOS+1
            jaout(KPOS)=jaseq(IJ)
            jbout(KPOS)=IGAP
500         CONTINUE
         RETURN
      END IF
      END
