C*********************************************************************
      subroutine hisplot(array,nval,diff,iout,nbuket,error)
C---------------------------------------------------------------------
C Author: Geoff Barton
C
C Routine to calculate a histogram from the data in real array(nval)
C using a bucket interval of diff, iout is the channel for output
C
C error is returned true if the max number of buckets is exceeded
C
C nbuket is the number of buckets calculated.
C---------------------------------------------------------------------
      integer nval,iout,i,j,maxbuk
      parameter(maxbuk=101)
C
C --
      real array(nval), amax,amin,diff,bmin,buckin(2,maxbuk)
C
C --  
      integer freq(maxbuk), nbuket,maxf,minf
C
C --
      logical error
      character pline*50
C
      data pline/'=================================================='/
C --
      error = .false.
      call rmm(array,nval,amin,amax)
C
      nbuket = int((amax-amin)/diff) + 1
C
      if(nbuket.gt.maxbuk)then
         error = .true.
         return
      end if
      bmin = amin
C
C --set up bucket range array
      do 10, i=1,nbuket
         buckin(1,i) = bmin
         buckin(2,i) = bmin + diff
         bmin = bmin + diff
10    continue
C
C --accumulate the values in buckets
      do 20, i = 1,nval
         do 30,j=1,nbuket
            if((array(i).gt.buckin(1,j)).and.
     -         (array(i).le.buckin(2,j)))then
               freq(j) = freq(j) + 1
               goto 20
            end if
30       continue
20    continue
C
      call imm(freq,nbuket,minf,maxf)
C
C --  plot out the results...
C
C      do 41,i=1,nbuket
C         write(6,*)i,buckin(2,i),freq(i),
C     -   int((float(freq(i))/float(maxf))*50.0)
C41    continue
      do 40,i=1,nbuket
         write(iout,100)i,buckin(2,i),freq(i),
     -   (pline(j:j),j=1,int((float(freq(i))/float(maxf))*50.0))
40    continue
C
100   format(1x,i5,f10.3,i10,' |',50a1)
C
C
      end
C
         
  
