C**********************************************************************
      subroutine wpatt(kpos,ibseq)
C----------------------------------------------------------------------
C writes out the pattern alignment in the form required by program pattern
C ibseq is the number of sequences inclusive of the pattern
C kpos is the length of the aligned pattern and sequence
C if kpos .eq. 0 then just the pattern details are output
C         .gt. 0 the just the current pattern alignment is output
C
C Author:  Geoff Barton
C----------------------------------------------------------------------
      include 'params.blk'
      include 'seqcha.blk'
      include 'gapmis.blk'
      include 'intseq.blk'
      include 'param2.blk'
C
      integer np,kpos,ibseq,i,k,start,end,npos
C
C --common block common to just multb and wpatt number of 

      integer*4 numsca,il

      common /mwpatt/ numsca,il
C
      np = 0
C
C --write out the pattern details if kpos is set to 0
C
      if(kpos.eq.0)then
         write(ipatt,100)'#Pattern'
         write(ipatt,101)numb(1),ibseq-1
         do 10,i=1,numb(1)
            write(ipatt,102)(seq(i,k),k=1,ibseq-1)
            if(i.lt.numb(1))then
              write(ipatt,101)gapmin(i),gapmax(i)
            end if
10       continue
      else
C        do the details of the current pattern alignment
         write(ipatt,100)'#Details'
         write(ipatt,100)idents(ibseq)
         write(ipatt,100)names(ibseq)
         write(ipatt,103)numb(ibseq)
         write(ipatt,101)numsca,il
         write(ipatt,104)match
         write(ipatt,100)'#Sequence'
C -- find start and end positions of sequence in output alignment
         call frange(kpos,start,end,ibseq)
         write(ipatt,102)(seq(i,ibseq),i=start,end)
         write(ipatt,100)'#Match'
C -- output the positions of each pattern element wrt the sequence start
         do 20,i=1,kpos
            if(seq(i,1).ne.' ')then
               np = np + 1
               npos = i - start + 1
               if(npos.lt.0.or.npos.gt.end)then
                  npos = 0
               end if
               write(ipatt,101)np,npos
            end if
20       continue
      end if
C
100   format(a)
101   format(i7,',',i7)
102   format(80a1)
103   format(i7)
104   format(f7.2)
C
      end
C
C******************************************************************
      subroutine frange(kpos,start,end,ibseq)
C------------------------------------------------------------------
C find the first and last non-blank aligned position in the ibseq'th
C sequence
C------------------------------------------------------------------
      include 'params.blk'
      include 'seqcha.blk'
      include 'gapmis.blk'
      include 'intseq.blk'
      include 'param2.blk'
C
      integer i,start,end,kpos,ibseq
C
      do 10,i=1,kpos
         if(seq(i,ibseq).ne.' ')then
           start = i
           goto 15
         end if
10    continue
C
15    continue
      do 20,i=kpos,1,-1
        if(seq(i,ibseq).ne.' ')then
           end = i
           return
         end if
20    continue
C
      end
C


