C************************************************************
      PROGRAM EXTRACT
C------------------------------------------------------------
C Program to extract a list of sequences from a PIR format
C sequence file and write them out to a separate file
C 
C Checks each sequence identifier against an internal list of 
C sequence identifiers, if a match is found, then the sequence
C is written to the output file.
C------------------------------------------------------------
C
      INTEGER MAXDIM,LEN,I,IOS,maxseq
      PARAMETER (MAXDIM=5000,maxseq=1000)
C
      CHARACTER*1 SEQ(MAXDIM)
      CHARACTER*80 LINE,IDENT*10,TITLE*80
      character*10 idents(maxseq)
C
      character*80 infile,ifile,ofile
      integer nseq,cindx,nid,nseq,j,i,endfin
C
      LOGICAL EOF,ERROR,found(maxseq)
C
      EOF=.FALSE.
      ERROR=.FALSE.
      nseq = 0
      nid = 0
C
      call initl(found,maxseq,.false.)
C
      CALL QMESS(6,5,1,'Enter Database filename: ',infile)
      OPEN(UNIT=1,FILE=infile,STATUS='OLD',IOSTAT=IOS)
      IF(IOS.NE.0)THEN
        CALL AMESS(6,1,'ERROR OPENING FILE',1,'E')
        stop
      END IF
C
      CALL QMESS(6,5,1,'Enter Identifier file: ',ifile)
      OPEN(UNIT=2,FILE=ifile,STATUS='OLD',IOSTAT=IOS)
      IF(IOS.NE.0)THEN
        CALL AMESS(6,1,'ERROR OPENING FILE',1,'E')
        stop
      END IF
C
      CALL QMESS(6,5,1,'Enter Output file: ',ofile)
      OPEN(UNIT=3,FILE=ofile,IOSTAT=IOS)
      IF(IOS.NE.0)THEN
        CALL AMESS(6,1,'ERROR OPENING FILE',1,'E')
        stop
      END IF
C
C --read the identifiers from ifile
C
      nseq = 0
1     continue
      nid = nid + 1
      read(2,20,end=200)idents(nid)
      call cucase(idents(nid))
20    format(A)
      goto 1
200   continue
      nid = nid -1
C
2     continue
C
C --  get the next seq
      CALL FSEQMF(1,6,EOF,ERROR,.TRUE.,' ',SEQ,MAXDIM,LEN,
     -IDENT,TITLE)
C
C --
      IF(ERROR)THEN
        CALL AMESS(6,1,'ERROR READING SEQUENCE',1,'E')
        stop
      END IF
      if(eof)then
        call amess(6,1,'End of sequence database',1,' ')
        write(6,600)nseq,nid
600     format(1x,i5,' Sequences selected',
     -        /1x,i5,' Sequences requested')
        do 22,i=1,nid
           if(.not.found(i))then
             write(6,20)idents(i)
           end if
22      continue
        stop
      end if
C
      do 23,i=1,nid
         if(ident(index(ident,';')+1:endfin(ident)).eq.
     -      idents(i)(:endfin(idents(i))))then

           found(i) = .true.
           seq(len+1) = '*'     
           write(3,30)ident,title
           write(3,31)(seq(j),j=1,len + 1)
30         format(A10/A80)
31         format(30(1x,a1))
           nseq = nseq + 1
           goto 2
         end if
23    continue
C
      goto 2
C
      END
C


