C**********************************************************
       SUBROUTINE INFO(NGAPS,NALIG,NIDENT,KPOS)
C-----------------------------------------------------------
C For the Ith and Jth integer sequences jaout(*),jbout(*) finds
C a) NGAPS    the number of internal gaps
C b) NALIG    the number of positions aligned
C c) NIDENT   the number of identical positions
C
C Author:  G. J. Barton
C----------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
C
      integer ngaps,nalig,nident,kpos
C
      INTEGER NAGAPS,K,START,FIN
      nagaps = 0
      k = 0
      start = 0
      fin = 0
C
C     a) locate the start terminal gap if there is one
C        bit messy, but it is late...
      START = 1
      IF(jaout(1).EQ.IGAP)THEN
         DO 10,K=2,KPOS
            IF(jaout(K).NE.IGAP)THEN
               START = K
               GOTO 1000
            END IF
10       CONTINUE
      ELSE IF(jbout(1).EQ.IGAP)THEN
         DO 20,K=2,KPOS
            IF(jbout(K).NE.IGAP)THEN
               START = K
               GOTO 1000
            END IF
20       CONTINUE
      END IF
1000  CONTINUE
C
C     b) locate end terminal gap if there is one
      FIN = KPOS
      IF(jaout(KPOS).EQ.IGAP)THEN
         DO 30,K=KPOS-1,1,-1
            IF(jaout(K).NE.IGAP)THEN
              FIN = K
              GOTO 2000
            END IF
30       CONTINUE
      ELSE IF(jbout(KPOS).EQ.IGAP)THEN
         DO 40,K=KPOS-1,1,-1
            IF(jbout(K).NE.IGAP)THEN
              FIN = K
              GOTO 2000
            END IF
40       CONTINUE
      END IF
2000  CONTINUE
C
C     c) go along each chain counting gaps
      CALL cgaps(START,FIN,jaout,KPOS,NAGAPS)
      CALL cgaps(START,FIN,jbout,KPOS,NGAPS)
      NGAPS = NGAPS + NAGAPS
C
C     d) find the number of aligned postions and identities
      NALIG = 0
      NIDENT = 0
      DO 50,K=START,FIN
         IF((jaout(K).NE.IGAP).AND.
     -      (jbout(K).NE.IGAP))THEN
             NALIG =  NALIG+1
         END IF
         IF(jaout(K).EQ.jbout(K))THEN
             NIDENT = NIDENT + 1
         END IF
50    CONTINUE
C
C
      END
C




