C**************************************************************
      integer function cindx(char1,char2)
C--------------------------------------------------------------
C Author: Geoff Barton 
C
C Identifies whether char2 is present in char1 without case 
C sensitivity.  Equivalent to INDEX but not case sensitive
C
C returns the first index of char2 in char1
C
C Uses a slow algorithm 
C
C Copyright (c)
C G. J. Barton Jan 1988
C-------------------------------------------------------------
      character*(*) char1,char2
      integer il1,il2,k,i,kp
      character*1 ccase
C
      cindx = 0
      il1 = len(char1)
      il2 = len(char2)
      if(il2.gt.il1)then
         return
      end if
C
C --  go down char1 looking for each element of char2 in turn
      do 10,i=1,il1-il2+1
        kp = i-1
        do 20,k = 1,il2
          kp = kp + 1
          if((char2(k:k).eq.char1(kp:kp)).or.
     -       (char2(k:k).eq.ccase(char1(kp:kp))))then
             if(k.eq.il2)then
                cindx = i
                return
             end if
          else 
             goto 10
          end if
20      continue
10    continue
C
      end
C
