C**************************************************************
      SUBROUTINE MLOOK(IBSEQ,IFIN,IDIV,KPOS)
C--------------------------------------------------------------
C Subroutine to make a look up table for subsequent reference by
C function SCORE and/or RECALL
C when aligning the IBSEQth sequence with the
C 1 to IFIN other sequences:  This should result in a time
C saving for large sequence alignments and when scanning the
C database using a multiple alignment.
C
C Author:  G. J. Barton
C--------------------------------------------------------------
C
      include 'params.blk'
      include 'matloc.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'dayhof.blk'
      include 'param2.blk'
C
C --
C
      integer ibseq,ifin,idiv,kpos

      INTEGER I,J,K
      REAL TEMP

      i=0
      j=0
      k=0
      temp=0.0
C
C --  loop over each amino acid type including gaps
      DO 10,I=0,23
C
C --     loop over the aligned positions
         DO 20,J=1,KPOS
C
C --        calculate mean score at this postion
            TEMP=0.0
            DO 30,K=1,IFIN
               IF(K.EQ.IBSEQ)GOTO 30
               TEMP = TEMP + DAY(ISEQ(K,J),I)
30          CONTINUE
            LOOKUP(J,I)=TEMP/IDIV
C --        cater for old version of program
            IF(COMND(26))THEN
              LOOKUP(J,I)=INT(LOOKUP(J,I))
            END IF
20       CONTINUE
10    CONTINUE
C
      END
C

