C********************************************************
      SUBROUTINE MULTA(ITS,KPOS)
C--------------------------------------------------------
C Author G.J. Barton: Copyright 1986 All rights reserved.
C
C Does the multiple alignments....
C
C V 4.0 allows block alignment with a block file on first
C iteration
C V 6.0 allows the tree order to be followed as indicated in 
C the tree_file (unit=itree)
C--------------------------------------------------------
C
      include 'params.blk'
      include 'intseq.blk'
      include 'seqcha.blk'
      include 'matloc.blk'
      include 'dayhof.blk'
      include 'gapmis.blk'
      include 'param2.blk'
C
C
      INTEGER ITS,IBSEQ,IFIN,KPOS,ALOC,BLOC,
     -        NEWKPOS,ITOTI,I,J,IDIV,ISTRT
C
      integer ijk,ijkl
C      ibseq = 0
C      ifin = 0
C      kpos = 0
C      aloc = 0
C      bloc = 0
C      newkpos = 0
C      itoti = 0
C      i = 0
C      j = 0
C      idiv = 0
C      istrt = 0
C
      IF(COMND(14))THEN
C       set istrt to the first seq in the seq file
        ISTRT=RBLOC(2,1)+1
      ELSE
        ISTRT = 1
      END IF
C
C     loop over number of sequences
      DO 1000,IBSEQ=ISTRT,INUMB
         IFIN=INUMB
         IF(ITS.EQ.1)THEN
           IFIN=IBSEQ-1
           IDIV=IFIN
           IF(IFIN.EQ.0)GO TO 1000
         ELSE
C          remove blanks from IBSEQ and compress all seqs
           IDIV=INUMB-1
           CALL SCOMP(IBSEQ,KPOS,INUMB)
         END IF
C
C
C --     generate lookup table for next alignment
         IF(COMND(24))THEN
C          generate conservation based matrix
           CALL MLOOK4(IBSEQ,IFIN,IDIV,KPOS)
         else if(comnd(39))then
C --       use the lookup table that has been defined by read_lookup
         ELSE
C --       use the matrix file to generate the lookup table
           CALL MLOOK(IBSEQ,IFIN,IDIV,KPOS)
         END IF
C
C --     write out lookup table if requested
         IF(COMND(23))THEN
            CALL WLOOK(KPOS)
         END IF
C
C --     write lookup table to save_lookup file if requested then stop
         if(comnd(37))then
           if(comnd(43))then
C             save brief format lookup table
              call bslook(kpos)
           else
C             save full format lookup table
              call slook(kpos)
           end if
           stop
         end if
C
C --     if no alignment has been specified then copy the seqs to
C        ioutseq and skip the rest
         if(comnd(42))then
           do 345,ijk=1,inumb
              do 345,ijkl = 1,numb(ijk)
                 ioutsq(ijk,ijkl) = iseq(ijk,ijkl)
345        continue
           goto 7000
         end if
C
C --     if variable gaps have been set the call sgap to set the pens
         IF(COMND(19))THEN
           CALL SGAP(KPOS)
C --       call version of recurs which copes with variable gaps
           CALL RECG(KPOS,NUMB(IBSEQ),GAP,
     -               ALOC,BLOC,IBSEQ,IFIN,IDIV)
         ELSE
C --       use the ordinary recurs
           CALL RECALL(KPOS,NUMB(IBSEQ),GAP,MATCH,
     -               ALOC,BLOC,IBSEQ,IFIN,IDIV)
         END IF
C         write(6,*)'!!!!'
C         write(6,*)'ifin:',ifin,'idiv:',idiv,'ibseq:',ibseq,'kpos:',kpos
C         write(6,6543)match
C6543     format(1x,'match',f50.40)
C         write(6,*)'min(kpos,numb(ibseq)',min(kpos,numb(ibseq))
C         write(6,*)'Normalised score ',match/min(kpos,numb(ibseq))
C         write(6,*)'aloc = ',aloc,' bloc = ',bloc
C
C--------ALIGN CURRENT SEQUENCES
C
         CALL ALMUL(KPOS,NUMB(IBSEQ),ALOC,BLOC,
     -              NEWKPOS,IBSEQ,IFIN)
         KPOS=NEWKPOS
C
C--------RENAME IOUTSQ MEMBERS TO ISEQ
C
         ITOTI=IFIN
         IF(ITS.EQ.1)ITOTI=IFIN+1
          DO 109,J=1,KPOS
            DO 109,I=0,ITOTI
              ISEQ(I,J)=IOUTSQ(I,J)
109      CONTINUE
C
C--------TEST IF ARRAY BOUNDS WILL BE EXCEEDED NEXT
C        this is set to MAXDIM-10 to allow smaller array dimensions
C        to be specified for ioutsq and iseq
C        WARNING.. I have not set traps for all all array bounds
C                  errors. A crash may occur if sequences close to
C                  MAXDIM are aligned
         IF(KPOS.GT.(MAXDIM-10))THEN
C          stop before array bounds are exceeded
           CALL KONBAK(KPOS,IBSEQ)
           IF(PFULL)THEN
              CALL WRITE6(KPOS,IBSEQ,COMND(15),COMND(16))
           END IF
C
           IF(PPRET)CALL PRETTY(iout,NHORIZ,IBSEQ,KPOS)
           call amess(iout,1,'ALIGNMENT DUMPED!!!!!!!!!!!!!!!',1,'*')
           call amess(iout,1,'LENGTH EXCEEDS MAXIMUM ALLOWED',1,'*')
           call amess(iout,1,'Try: larger gap_penalty or',0,' ')
           call amess(iout,0,'     shorter sequences(!)',0,' ')
           WRITE(6,*)'MAX OUTPUT LENGTH EXCEEDED'
           STOP
         END IF
1000  CONTINUE
      IBSEQ=IBSEQ-1
      CALL KONBAK(KPOS,IBSEQ)
C
C      do 222,i=1,kpos
C         write(6,6666)(iseq(j,i),j=1,6)
C222   continue
C6666  format(1x,6i2)
C
C --continuation if non alignment is specified
7000  continue
C
C --13/9/91 - comment this out for now - I think it ought to stay at ibseq
C      if(comnd(42))then
C         ibseq=ibseq-1
C      end if
C
C
      if((comnd(207) .and. its .eq. nits) .or. .not.comnd(207))then
C        only output the alignment if LAST_IT is set and this is the last iteration
C        or if LAST_IT is not set
         IF(TEST) CALL GCHECK(IBSEQ,kpos,6)
         IF(PFULL)THEN
           CALL WRITE6(KPOS,IBSEQ,COMND(15),COMND(16))
         END IF
         IF(PPRET)CALL PRETTY(iout,NHORIZ,IBSEQ,KPOS)
         IF(TEST) CALL WCHECK(IOUT,IBSEQ,KPOS)
      end if 
C
      END
C
