struct parameters {
	char property_file[1000];
	char align_file[1000];
	int  align_size;
	int  Nmax;
	int  window;
	int  min_n_prop;
	int  n_gaps_tolerated;
	int initial_seed;
	int display_parameters;
	int q_only;
	int *omit;
	float fraction_ignored;
};
                                /* Zvelebil Conservation Value Store				*/
struct zv {
    int *zva;                   /* ZCVs in cluster A						*/
    int *zvb;                   /* ZCVs in cluster B						*/
};

/* Structure for storing property type matrix data			*/
struct pmtrx {
    int  pcode;     /* Symbol to which the property types are assigned	*/
    int *ptype;     /* Property type matrix				*/
    };
struct slist {
    char *aas;   /* list of amino acid symbols used in matrix pmtrx	*/
    char **pnames;  /* property type name				*/
    int pno;        /* number of struct pmtrx records ie. property types*/
    int maxnoprop;  /* maximum number of symbols per property		*/
    int syno;       /* number of symbol types across *ptype matrix	*/
    struct pmtrx *apm; /* array of property matrices			*/
    };


                                /* Command structure - file/command line input routed into here */
                                /* then out to the rest of the program                          */
struct cstruct {
    char *blocfile;             /* name of file containing multiple sequence alignment          */
    char *pfile;                /* name of file in which property type matrix is stored         */
    char *out;                  /* user-defined output filename to replace dating system        */
    int  scno;                  /* number of start cluster (nearest dendrogram trunk)           */
    int  ecno;                  /* number of end cluster   (nearest leaves)                     */
    int  cv;                    /* controls the type of sort applied to the property type data  */
    int  qz;                    /* controls datafile 2 */
    char *tordfile;             /* name of order file in use - NULL if internal dendrogram used */
    char *tc;
    char *treefile;             /* name of tree file in use  - NULL if internal dendrogram used */
    };

/************************************************************************************************/
#define MAXnseq 1000 
#define MAXslen 2000
#define MAXilen 1000
#define MAXtlen 1000
#define MAXnbloc 1000


/* Matrix file structure - eg. Dayhoffs matrix */

struct pmatrix {
    char *title;    /* title of matrix */
    char *indx;	    /* Index to matrix - ie amino acid codes */
    int  inlen;	    /* number of residues per line */
    int **array;    /* the actual pair score array */
};

/* Standard structure for storing protein sequence data */

struct seqdat {	/* all lengths include char terminator and [0] */
    int ilen;	/* length of identifier*/
    char *id;	/* identifier */
    int tlen;	/* length of title */
    char *title;	/* title */
    int slen;	/* length of sequence*/
    char *seq;	/* sequence */
};

/*  mseq Structure for storing multiply aligned sequence data - 
    arranged so that
    aligned positions in different sequences are adjacent 
    This structure could easily be extended to include additional annotations
    (eg. the name of the alignment, its history, etc. etc.) can be added
    without having to modify existing code (I hope..)
    */

struct sident {
    char *id;	    /* sequence id */
    char *title;    /* sequence title */
    int uid;	    /* unique identifier number for sequence */
};

struct alseq {
    char *line;	    /* one position in the sequence alignment */
};

struct mseq {
    int nseq;		/* number of sequences in this aligned bloc */
    int blen;		/* overall aligned length of the bloc */
    struct sident *itd;	/* list of id,title,uid structures */
    struct alseq *bloc;	/* pointer to list of blen lines of the alignment
			   structure used to allow future expansion of info
			   on a per-aligned line basis (eg. presence of 
			   flexible gap, etc)*/
};

double factorial();
long int nCr();
int *cons_test();
struct slist readprop();
float ran3();
int **comb();
struct slist readprop();
struct cstruct drive();
