/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Asim S. SIddiqui

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/* 
 * Title
 *     n_res_per_seg.c
 * Purpose
 *     contains the code for the number of residues per segment screen
 * SccsId:
 *     %W%   %U%   %E%
 */

#include <local.h>
#include <malloc.h>
#include <stdlib.h>
#include <array.h>
#include <stdio.h>
#include <rdssp.h>
#include <asd_structs.h>
#include <string.h>
#include <gjutil.h>
#include <asstr_util.h>
#include <ass_stamp_utils.h>
#include <asd_make_domains.h>
#include <asd_contacts_utils.h>
#include <rbr_newlib.h>
#include <asd_get_params.h>


#define SIZE 50
#define MIN_RES_PER_SEG 50


int
asa_cmp_int(int *left, int *right)
{
    return(*left - *right);
}

void
main(int argc, char *argv[])
{
    int num_domains;                     /* number of domains       */
    int num_atoms;                       /* number of atoms         */
    char code_t[5];
    bool_t ok;
    bool_t more;
    bool_t match1, match2;
    bool_t fail;
    int i;                               /* loop counter            */
    int j, k, l;                         /* loop counter            */
    int min_domain;                      /* lowest domain           */
    int max_domain;                      /* highest domain          */
    int size;
    int size_d;
    int n_obj;
    int n_found;
    int n_to_find;
    int n_conn;
    int n_seg;
    int r1[10];
    int r2[10];
    int assigned[SIZE];
    int max_res, min_res;
    float dum_f;
    int dum_i;
    int match;
    int dum_i2;
    FILE *test;
    struct brookn *dssp_bn;
    struct domain_loc *domain;           /* domain structure        */
    char *code;                          /* pdb code                */
    char *name_file;
    char name[120];                      /* name                    */
    char code_id[15];                     /* pdb code                */
    char code_new_id[15];                 /* pdb code                */
    char *output_file_name;              /* output file name        */
    char *rasmol_file_name;              /* rasmol file name        */
    char *dssp_file_name;                /* dssp file name          */
    char *contacts_file_name;            /* contacts file name      */
    char *pdb_file_name;                 /* pdb file name           */
    char *ss;                            /* secondary struct        */
    char *sheet;                         /* sheet structure         */
    char *env;
    char cid;                            /* chain identifier        */
    

    if (argc != 2) {
        fprintf(stdout, "usage : n_res_per_seg <stamp_file>\n");
        exit(-1);
    } /*if*/

    if((env=getenv("DOMAKDIR"))==NULL) {
        printf("Error must set enviroment variable DOMAKDIR\n");
        exit(-1);
    } /*if*/


    GJinitfile();

    fail = FALSE;
/* call function that reads and checks domains */
    domain = ass_read_stamp(argv[1], &num_domains);

    i = 0;
    while (i < num_domains) {
        min_domain = i;

        j = 0;
        while (domain[min_domain].id[j] != '-' && domain[min_domain].id[j] != '\0') {
            if (j < 4) {
                code_t[j] = domain[min_domain].id[j];
            } /*if*/
            code_id[j] = domain[min_domain].id[j];
            j++;
        } /*if*/
        code_t[4] = '\0';
        code_id[j] = '\0';
        i = num_domains;
        max_domain = i;

        dssp_file_name = RBR_getfile(code_t, asstr_cat_safe(asstr_save(env),
                                                    "/dssp_files"), 4, stdout);
        dssp_bn = get_bn(dssp_file_name, &num_atoms);

        j = min_domain;
        while (j < max_domain) {
            k = 0;
            while (k < domain[j].nobj) {
                l = 0;
                match = 0;
                match1 = FALSE;
                match2 = FALSE;
                while (l < num_atoms && (match1 == FALSE || match2 == FALSE)) {
                    if (dssp_bn[l].n == domain[j].start[k].n &&
                        dssp_bn[l].cid == domain[j].start[k].cid &&
                        dssp_bn[l].in == domain[j].start[k].in &&
                        match1 == FALSE) {
                        domain[j].start[k].n = l;
                        match++;
                        match1 = TRUE;
                    } /*if*/
                    if (dssp_bn[l].n == domain[j].end[k].n &&
                        dssp_bn[l].cid == domain[j].end[k].cid &&
                        dssp_bn[l].in == domain[j].end[k].in &&
                        match2 == FALSE) {
                        domain[j].end[k].n = l;
                        match++;
                        match2 = TRUE;
                    } /*if*/
                    l++;
                } /*while*/
                if (match != 2) {
                    printf("ERROR not matched\n");
                } /*if*/
                k++;
            } /*while*/
            j++;
        } /*while*/


        j = min_domain;
        k = 0;
        min_res = domain[j].start[k].n;
        max_res = domain[j].start[k].n;
        while (j < max_domain) {
            k = 0;
            while (k < domain[j].nobj) {
                if (min_res > domain[j].start[k].n) {
                    min_res = domain[j].start[k].n;
                } /*if*/
                if (max_res < domain[j].end[k].n) {
                    max_res = domain[j].end[k].n;
                } /*if*/
                k++;
            } /*while*/
            j++;
        } /*while*/

        n_obj = 0;
        size = max_res - min_res + 1;
        j = min_domain;
        while (j < max_domain) {
            k = 0;
            n_conn = 0;
            while (k < domain[j].nobj) {
                ok = TRUE;
                l = 0;
                while (l < domain[j].nobj) {
                    if (domain[j].start[k].n == (domain[j].end[l].n + 1)) {
                        ok = FALSE;
                    } /*if*/
                    l++;
                } /*while*/
                if (ok) {
                    n_conn++;
                } /*if*/
                ok = TRUE;
                l = 0;
                while (l < domain[j].nobj) {
                    if (domain[j].end[k].n == (domain[j].start[l].n - 1)) {
                        ok = FALSE;
                    } /*if*/
                    l++;
                } /*while*/
                if (ok) {
                    n_conn++;
                } /*if*/
                k++;
            } /*while*/
            n_seg = n_conn / 2;
            k = 0;
            size = 0;
            while (k < domain[j].nobj) {
                size = size + (domain[j].end[k].n -domain[j].start[k].n + 1);
                assigned[k] = 0;
                k++;
            } /*while*/
            n_obj = n_obj + n_seg;
            if ((max_domain - min_domain) > 1 && n_seg > 1) {
                if (((float) size / (float) n_seg) < MIN_RES_PER_SEG) {
                    fail = TRUE;
                } /*if*/
            } /*if*/ 
            j++;
        } /*while*/


        j = min_domain;
        n_obj = 0;
        while (j < max_domain) {
            k = 0;
            n_conn = 0;
            size_d = 0;
            n_obj = n_obj + domain[j].nobj;
            while (k < domain[j].nobj) {
                size_d = size_d + domain[j].end[k].n - domain[j].start[k].n + 1;
                k++;
            } /*while*/

            j++;
        } /*while*/

        free(dssp_file_name);
    } /*while*/

    free(domain);

    if (fail == TRUE) {
        printf("FAIL ");
    } else {
        printf("PASS ");
    } /*if*/
} /*main*/

