/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK is Copyright (1995) R. B. Russell and G. J. Barton


 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <math.h>
#include "structs.h"

int calc(info,res,outfile,VDW,binary,parms)
struct protein info;
struct residue *res;
char *outfile;
struct radii *VDW;
int binary;
struct parameters parms;
{
    char ctype;
    char aa1_1,aa1_2;
    int i,j,k,l,counter,m;
    int hbond,elec,s_s,half_elec,hydrophobic,tooclose;
    int maink,mainl;
    int start,astart;
    int in_contact;

    FILE *out;

    float sqD,D;
    float SQCC,SQHYDROPHOBIC;

    float dist();
    float sqdist();

    SQCC=parms.CC_DISTANCE*parms.CC_DISTANCE;
    SQHYDROPHOBIC=parms.HYDROPHOBIC*parms.HYDROPHOBIC;

    if(binary) {
      if((out=fopen(outfile,"r"))!=NULL) {
	 printf("error: file %s already exists\n",outfile);
	 return -1;
      }
      out=fopen(outfile,"wb");
    } else {
      if((out=fopen(outfile,"r"))!=NULL) {
	 printf("error: file %s already exists\n",outfile);
	 return -1;
      }
      out=fopen(outfile,"w");
    }

    printf("calculating contacts...\n");
    counter=1;
    for(i=0; i<info.num; i++) {
	if(i==0) start=0; 
	else start=i+1;
	for(j=start; j<info.num; j++) {
	  in_contact=0;
/*
	printf("# %d,(x,y,z):(%6.4f,%6.4f,%6.4f) to ",i, res[i].atoms[1][0],res[i].atoms[1][1],res[i].atoms[1][2]);
	printf("# %d,(x,y,z):(%6.4f,%6.4f,%6.4f) = ",j, res[j].atoms[1][0],res[j].atoms[1][1],res[j].atoms[1][2]);
*/

	/* We'll do an initial check on C-alpha's... if they
	 *  are more than 21 angstroms apart we'll skip 
	 *  comparison of these two residues, we'll assume
	 *  that CA is the 2nd atom in each residue */
        if(res[i].num>0 && res[j].num>0)
	if( (sqD=sqdist(res[i].atoms[1],res[j].atoms[1]))<SQCC || i==0 ) {
/*	   printf("%6.4f A.\n",sqD); */
	   /* If the CA's are less than CC_DISTANCE apart, then calculate all the
	    *   distances */
	   for(k=0; k<res[i].num; ++k) {
	     maink=(k<4) || (strcmp(res[i].atname[k]," OXT")==0); /* assuming standard brookhaven format */
	     if(j==0) astart=k+1;
	     else astart=0;
	     for(l=astart; l<res[j].num; ++l) {
	       m=check(res[i].atname[k],res[i].atoms[k],res[j].atname[l],res[j].atoms[l],&sqD,&hbond,&elec,&s_s,&half_elec,&hydrophobic,&tooclose,SQHYDROPHOBIC,VDW,parms);
	       if(m) in_contact=1;  /* are the residues in contact? */
	       /* hbond is 1 if a this contact is a potential H-bond 
		* elec is 1 if this contact is an electrostatic one
		* s_s is 1 if this is a disulphide bond 
		* tooclose is 1 if this contact is too close 
		*   (H-bond or S-S < 1.2 A; others < 2.0 A)
		* maink is 1 if the kth atom is main chain (atoms 0--3)
		* mainl "  "  "  "  lth   "   "  "    "      "      " */
	       mainl=(l<4) || (strcmp(res[j].atname[l]," OXT")==0);
	      if( (m) &&
	       ( (!maink && !mainl)  || ((j-i)>1) )
	       /*  ^ all main chain contacts on adjacent residues are
		*  ignored */
	       ) {
	      /* determining the contact type */
	      if(tooclose)   ctype='c';   /* displays either c = Too close contact */
	      else if(hbond) ctype='h';   /*                 h = H-bond */
	      else if(elec)  ctype='e';   /*                 e = electrostatic */
	      else if(s_s) { 
		  ctype='s';              /*  		     s = disulphide bond */
		  res[i].s_s=1; res[j].s_s=1;
		  }
	      else if(hydrophobic) 
		  ctype='l'; 	          /* 	   	     l = hydrophobic contact */
	      else if(half_elec)
	  	  ctype='p';              /*		     p = half electrostaic (polar) contact */
	      else
		  ctype='n';              /* 	             n = non-electrostatic in the output file */

	      /* output format */
/*	      if(counter>9999) counter=9999; */
	      if(binary) {
		/* Binary output */
		aa1_1=RBR_a3to1(&res[i].resname[0]);
		aa1_2=RBR_a3to1(&res[j].resname[0]);
		D=(float)sqrt(sqD);

		writecbin(counter,
		  aa1_1,
		  res[i].ksnum,
	          res[i].resnum,
		  &res[i].atname[k][0],
	          res[i].atnum[k],
		  res[i].kssum,
		  aa1_2,
		  res[j].ksnum,
		  res[j].resnum,
		  &res[j].atname[l][0],
		  res[j].atnum[l],
		  res[j].kssum,
		  ctype,D,
		  out,stdout);

	      } else { 
		/* ASCII output */
	        fprintf(out,"%4d ",counter);
	        fprintf(out,"%s %4d %c %4d %c %s %5d %c  ",
	  	   res[i].resname, res[i].ksnum,
		   res[i].resnum.cid, res[i].resnum.n, res[i].resnum.in, 
		   res[i].atname[k], res[i].atnum[k],
		   res[i].kssum);
	        fprintf(out,"%s %4d %c %4d %c %s %5d %c  ", 
		   res[j].resname, res[j].ksnum,
		   res[j].resnum.cid, res[j].resnum.n, res[j].resnum.in, 
		   res[j].atname[l], res[j].atnum[l],
		   res[j].kssum);
	        fprintf(out,"%c ",ctype);
	        fprintf(out,"%4.2f ",(float)sqrt(sqD));
	        fprintf(out,"\n");
	     }
	      counter++;
	      /* increment the number of contacts that each residue makes */
	      if( (hydrophobic && elec) || (hydrophobic && half_elec)) 
		 printf("error...\n");
	      res[i].contacts++; res[j].contacts++;
	      res[i].sidecont+=(!maink); res[j].sidecont+=(!mainl);
	      res[i].hyd+=hydrophobic; res[j].hyd+=hydrophobic;
	      res[i].sidehyd+=(hydrophobic && !maink); res[j].sidehyd+=(hydrophobic && !mainl);
	      res[i].elec+=(hbond || elec); res[j].elec+=(hbond || elec); 
	      res[i].sideelec+=((hbond || elec) && !maink); res[j].sideelec+=((hbond || elec) && !mainl);
	      res[i].polar+=half_elec; res[j].polar+=half_elec;
	      res[i].sidepolar+=(half_elec && !maink); res[j].sidepolar+=(half_elec && !mainl);

	      } else {
		}
	      }}
	} else { /* skipping due to > 50 angstrom separation */
	} /* End of if... */
	/* if the two residues in question are in contact with each other, then
	 *  increment res[?].nrc */
	if(in_contact) { res[i].nrc++; res[j].nrc++; }
	if(in_contact && ((j-i)>10) && ((j-i)<=20) ) { res[i].med_nrc++; res[j].med_nrc++; }
	if(in_contact && ((j-i)>20)) { res[i].long_nrc++; res[j].long_nrc++; }
       } /* End of for(j... */
      } /* End of for(i... */
      printf("                 done.\n");
      fclose(out);
}
