/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK is Copyright (1995) R. B. Russell and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include "structs.h"

/* Given a pdb file name, this routine calculates atom--atom contacts */
int contacts(pdbfile,dsspfile,outfile1,outfile2,outfile3,S,VDW,binary,parms)
char *pdbfile,*dsspfile;
char *outfile1,*outfile2,*outfile3;
int S; /* if S is one then dsspfile is a summary file not a DSSP file */
struct radii *VDW;
int binary;
struct parameters parms;
{
	int i,j,k;
	int *ao,*rn;
	char *kssum;
	char *ksseq;
	FILE *f;

	struct residue *res; /* allocations for these structures do */
	struct protein info; /*  not take place in this routine */

	int *get_n();
	int *get_acc();
	char *get_ss();
	struct residue *getdat();

/*	printf("S=%d\n",S); */
	if((f=fopen(pdbfile,"r"))==NULL) {
	   printf("error: file %s does not exist\n",pdbfile);
	   return -1;
	}
	/* Check is assumed to take place prior to this routine */
	res=getdat(f,&info,&res,parms.WATERS,parms.ACEFOR,parms.FORCE); 
/*	system("pstat -s"); */
	if(strcmp(res[0].resname,"error")==0) return 1;
	/* Get coordinates and information from file */
	fclose(f);
	
	if(S==0 && dsspfile[0]!='\0') {
	  printf("reading DSSP file...\n");
	  ao=get_acc(dsspfile,&i);
	  kssum=get_ss(dsspfile,&i);
	  ksseq=get_aa(dsspfile,&i);
	  for(j=0; j<strlen(ksseq); ++j) {
	     if(ksseq[j]=='!') {
		ksseq[j]=' ';
		kssum[j]='!';
 	     }
	     if(ksseq[j]>='a' && ksseq[j]<='z') ksseq[j]='C';
	     /* DSSP's disulfide notation */ 
	  }
	  RBR_rmsp(ksseq);
	  rn=get_n(dsspfile,&i);
	  /* Since the dssp routine will return
	   *  a sequence including '!'s, we need to
	   *  remove them prior to assigning 'res'.
	   *  N.B. note k=0 refers to heteroatoms */
	  k=0;for(j=0; j<strlen(kssum); ++j) 
	     if(kssum[j]!='!') {
	        if(kssum[j]!=' ') res[k+1].kssum=kssum[j];
		else res[k+1].kssum='-';
		res[k+1].acc=ao[j];
		res[k+1].ksnum=j+1;
/*		printf("n: %d, sum: %c, acc: %d\n",k+1,res[k+1].kssum,res[k+1].acc); */
		++k;
		}
	  if(k!=(info.num-1)) {
	     printf("error: DSSP file and PDB file do not correspond\n");
	     printf(" DSSP file has %d residues, PDB file has %d\n",k,(info.num-1));
	     printf(" Trying to find the position of the error...\n");
	     for(j=0; j<strlen(ksseq); ++j)
	       if(res[j+1].aa!=ksseq[j]) {
		  printf("first disagreement at position %d\n",j+1);
		  k=j+1;
		  break;
	       }
	     printf("DSSP: "); for(j=0; j<k; ++j) printf("%c",ksseq[j]); printf("\n");
	     printf("PDB:  "); for(j=0; j<k; ++j) printf("%c",res[j+1].aa); printf("\n");
	     return -1;
	  }
	  printf("               done.\n");
	} 
	if(calc(info,res,outfile1,VDW,binary,parms)==-1) return -1; 
	   /* Calcualate contacts */


	if((f=fopen(outfile2,"r"))!=NULL) {
	   printf("error: file %s already exists",outfile2);
	   return -1;
	}
	f=fopen(outfile2,"w");
	for(i=0; i<info.num; ++i) {
	   if(strcmp(res[i].resname,"CYS")==0 && (res[i].s_s==0)) 
	      strcpy(res[i].resname,"CYH");
	   /* Data are output as follows:
	      counter,
	      brookhaven number (chain number insertion),
	      name, 
	      total contacts, total side-chain contacst,
	      total hydrophobic contacts, side-chain hydrophobic contacts,
	      total electrostatic contacts, side-chain electrostatic contacts,
	      total polar contacts, side-chain polar contacts,
	      DSSP accessibility, DSSP SS summary
	    */
	   fprintf(f,"%4d %c %4d %c %s %3d %3d %3d %3d %3d %3d %3d %3d",
		  res[i].ksnum,
		  res[i].resnum.cid, res[i].resnum.n, res[i].resnum.in,
		  res[i].resname, 
		  res[i].contacts, res[i].sidecont, 
		  res[i].hyd, res[i].sidehyd,
		  res[i].elec, res[i].sideelec,
		  res[i].polar, res[i].sidepolar
		  );
	   if(dsspfile[0]!='\0') {
	      fprintf(f,"%4d %c ",res[i].acc,res[i].kssum);
	      }
	   fprintf(f,"\n");
	   }
	fclose(f);

/*	if((f=newfile(outfile3))==NULL) return -1;
	for(i=0; i<info.num; ++i) {
	   fprintf(f,"%4d %c %4d %c %s %4d %3d %3d %3d\n",
	   i+1, 
           res[i].resnum.cid, res[i].resnum.n, res[i].resnum.in,
	   res[i].resname, res[i].contacts,res[i].nrc,res[i].med_nrc,res[i].long_nrc);
	}
	fclose(f);
*/
	free((char*)kssum); 
	/* free(ao); free(rn);   */

	/* Freeing memory associated with `res'  */
	for(i=0; i<info.num; ++i) {
	     for(j=0; j<res[i].j; ++j) {
		 free((char*)res[i].atoms[j]);
		 free((char*)res[i].atname[j]);
		 }
	     free((char*)res[i].atoms); 
	     free((char*)res[i].atname); free((char*)res[i].atnum); 
	     free((char*)res[i].occ); free((char*)res[i].B);
	     }
	free((char*)res);  /* res is just a one dimensional array of residues */
	return 0; /* 1 indicates something is wrong with the pdb file (see above) */
}
