/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Geoffrey J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/* utility.h function definitions */

void *GJmalloc(size_t);
void *GJrealloc(void *,size_t);
void *GJmallocNQ(size_t);
void *GJreallocNQ(void *,size_t);
void GJfree(void *);
void GJerror(const char *);
char *GJstrdup(const char *);
char *GJstoupper(const char *);
char *GJstolower(const char *);
char *GJstoup(char *);
char *GJstolo(char *);
FILE *GJfopen(const char *, const char *,int);
int  GJfclose(FILE *,int);
void GJinitfile();
char *GJfnonnull(char *);
char *GJstrappend(char *,char *);
char *GJremovechar(char *,char);
char *GJstrcreate(size_t, char *);
char *GJstrlocate(char *,char *);
char *GJsubchar(char *,char,char);
char *GJstrtok(char *,const char *);
void error(const char *, int);
unsigned char **uchararr(int,int);
#ifdef VAX
char **chararr(int,int);
void GJCinit(char **,int ,int ,char );
#else
signed   char **chararr(int,int);
void GJCinit(signed char **,int ,int ,char );
#endif
void mcheck(void *, char *);
char *GJstrblank(char *, int);
void GJUCinit(unsigned char **,int ,int ,unsigned char );
char *GJcat(int N,...);
char *GJGetToken(FILE *in, const char *delim);



