/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell


 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/* $Id: getfile.c,v 1.5 2004/09/10 14:39:17 geoff Exp $ */

#include <stdio.h>

#include <math.h>

#define MAXLINE 100 

/* getfile: 
 *  opens a file containing a list of appropriate directories, suffixes and
 *  prefixes.  It then makes combinates of these with the supplied code
 *  to see if a file exists 
 *
 * Allocates memory for a string corresponding to the filename read in,
 *  then returns this string or '\0' if none is found */
char *RBR_getfile(char *code,char *dirfile,int code_length,FILE *OUTPUT)
{
    char *temp;
    char *dir;
    char *buff;
    char prefix[10],suffix[10];
    char *CODE;
    char a;

    int i,j,found;

    FILE *DIR;

    dir=(char*)malloc(200*sizeof(char)); 
    buff=(char*)malloc(200*sizeof(char));
    temp=(char*)malloc(200*sizeof(char)); 
    CODE=(char*)malloc((code_length+2)*sizeof(char));

    a = code[code_length];
    code[code_length]='\0'; /* truncates the code if necessary */
    for(i=0; i<strlen(code); ++i) CODE[i]=RBR_ltou(code[i]); /* upper case code */
    CODE[code_length]='\0';

    if((DIR=fopen(dirfile,"r"))==NULL) {
	fprintf(OUTPUT,"getfile> error: no directories file ");
	fprintf(OUTPUT,dirfile);
	fprintf(OUTPUT," found\n");
	temp[0]='\0';
	return temp;
    }
    found=0;

    while(fgets(buff,MAXLINE,DIR)!=NULL) {
	sscanf(buff,"%s %s %s",dir,&prefix[0],&suffix[0]);
	sprintf(temp,"%s/",dir);
	if(prefix[0]!='_') 
	    sprintf(&temp[strlen(temp)],"%s",prefix);
	sprintf(&temp[strlen(temp)],"%s",code);
	if(suffix[0]!='_') 
	    sprintf(&temp[strlen(temp)],"%s",suffix);
	if(RBR_testfile(temp)) { 
	    found=1; 
	    break; 
	}
	sprintf(temp,"%s/",dir);
	if(prefix[0]!='_') 
	    sprintf(&temp[strlen(temp)],"%s",prefix);
	sprintf(&temp[strlen(temp)],"%s",CODE);
	if(suffix[0]!='_') 
	    sprintf(&temp[strlen(temp)],"%s",suffix);
	if(RBR_testfile(temp)) { 
	    found=1; 
	    break; 
	}
    }

    if(!found) {
/*	   fprintf(OUTPUT,"error: no file found for %s \n -- have you supplied the right directories/prefix/suffix?\n",code); */
	temp[0]='\0';
    }
    fclose(DIR);
    free(dir); 
    free(buff);
    free(CODE);
    code[code_length]=a;

    return temp;
}
