/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <malloc.h>

#define RBR_a3to1_acids3 "ALA ARG ASN ASP CYS GLN GLU GLY HIS ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL ASX GLX UNK CYH HET"
#define RBR_a3to1_acids1 "ARNDCQEGHILKMFPSTWYVBZXch"

/* Converts three letter amino acid code to one letter
 *  amino acid code 
 * Note: CYS refers to cystine, CYH refers to cysteine */

char RBR_a3to1(a3) 
char *a3;
{
	int i;
	char new;

	new='X';
	for(i=0;i<strlen(RBR_a3to1_acids1); i++) {
	   if (strncmp(&RBR_a3to1_acids3[i*4],a3,3) == 0) 
	      new=(char)RBR_a3to1_acids1[i];
	}   /* end of for  */

	return(new);
} /* end of function */
