/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was written by Robert B. Russell

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include <domain.h>


/* Counts the number of domain descriptors in a file ignoring comments */
int count_domain(IN)
FILE *IN;
{
	int N,col,comment;
	char c;

	N=0;
	comment=0;
	col=0;
	while((c=getc(IN))!=(char)EOF) {
	  if((col==0) && (c=='#' || c=='%')) {
	     comment=1;
	  }
	  if(col!=0 && !comment && c=='{') 
	     N++;
	  col++;
	  if(c=='\n') { 
	     col=0; 
	     comment=0; 
	  }
	}
	return N;
}
