#include <stdio.h>
#include <gjutil.h>
#include <gjnoc.h>

void printvalues(struct gjnoc2 *value,int n,char *type);
void freevalue(struct gjnoc2 *value, int n);
/* test program for gjnoc2 routine */
/* does a variety of cluster analyses on the data */
/* G. J. Barton August 2002*/

main(int nargs, char *argc[])
{
  struct gjnoc2 *value;
  
  double **arr;
  int n;
  char **idents;

  int i,j;

  /* allocate and read in the upper diagonal array - only if not noc*/
  fprintf(stderr,"Reading Upper Diagonal\n");
  fscanf(stdin,"%d",&n);
  idents = read_idents(stdin,n);
  arr = read_up_diag(stdin,n);

  value = GJnoc2(arr,idents,n,"noc dis single");
  printvalues(value,n,"noc dis single");
  freevalue(value,n-1);

  value = GJnoc2(arr,idents,n,"noc sim single");
  printvalues(value,n,"noc sim single");
  freevalue(value,n-1);

  value = GJnoc2(arr,idents,n,"noc dis complete");
  printvalues(value,n,"noc dis complete");
  freevalue(value,n-1);

  value = GJnoc2(arr,idents,n,"noc sim complete");
  printvalues(value,n,"noc sim complete");
  freevalue(value,n-1);

  value = GJnoc2(arr,idents,n,"noc sim complete cut 90");
  printvalues(value,n,"noc sim complete");
  freevalue(value,value->nclust);

  value = GJnoc2(arr,idents,n,"noc sim complete cut 25");
  printvalues(value,n,"noc sim complete");
  freevalue(value,value->nclust);

  value = GJnoc2(arr,idents,n,"noc dis complete cut 25");
  printvalues(value,n,"noc dis complete");
  freevalue(value,value->nclust);

  value = GJnoc2(arr,idents,n,"noc dis complete cut 90");
  printvalues(value,n,"noc dis complete");
  freevalue(value,value->nclust);
  

  for(i=0;i<n;++i) {
    GJfree(idents[i]);
  }
  GJfree(idents);

  for(i=0;i<(n-1);++i){
	GJfree(arr[i]);
  }
  GJfree(arr);

}

void printvalues(struct gjnoc2 *value,int n,char *type)
{
  int i,j;
  printf("%s: nclust:  %d\n",type, value->nclust);
    
  for(i=0;i<value->nclust;++i) {
    printf("%d:%g\n",value->clusters[i].n,value->clusters[i].score);
    for(j=0;j<value->clusters[i].n;++j) {
      printf("%d ",value->clusters[i].members[j]);
    }
    printf("\n");
  }
}
  
void freevalue(struct gjnoc2 *value, int n)
{
  int i;
  for(i=0;i<n;++i){
	GJfree(value->clusters[i].members);
  }
  GJfree(value->clusters);
  GJfree(value);
}



