#include <stdio.h>
#include <gjutil.h>
#include <gjnoc.h>

void printvalues(struct gjnoc *value,int n,char *type);
void freevalue(struct gjnoc *value, int n);
/* test program for gjnoc routine */
/* does a variety of cluster analyses on the data */
/* G. J. Barton July 1995 */

main(int nargs, char *argc[])
{
  struct gjnoc *value;
  
  double **arr;
  int n;
  char **idents;

  int i,j;

  /* allocate and read in the upper diagonal array - only if not noc*/
  fprintf(stderr,"Reading Upper Diagonal\n");
  fscanf(stdin,"%d",&n);
  idents = read_idents(stdin,n);
  arr = read_up_diag(stdin,n);

  value = GJnoc(arr,idents,n,"noc dis single");
  printvalues(value,n,"noc dis single");
  freevalue(value,n);

  value = GJnoc(arr,idents,n,"noc sim single");
  printvalues(value,n,"noc sim single");
  freevalue(value,n);

  value = GJnoc(arr,idents,n,"noc dis complete");
  printvalues(value,n,"noc dis complete");
  freevalue(value,n);

  value = GJnoc(arr,idents,n,"noc sim complete");
  printvalues(value,n,"noc sim complete");
  freevalue(value,n);

  for(i=0;i<n;++i) {
    GJfree(idents[i]);
  }
  GJfree(idents);

  for(i=0;i<(n-1);++i){
	GJfree(arr[i]);
  }
  GJfree(arr);

}

void printvalues(struct gjnoc *value,int n,char *type)
{
  int i,j;
  printf("%s: nclust:  %d\n",type, n);
  printf("ORDER\n i: value->order[i]\n");
  for(i=0;i<n;++i) {
    printf("%d: %d\n",i,value->order[i]);
  }
    
  for(i=0;i<(n-1);++i) {
    printf("%d\n",value->clusters[i].a.number);
    for(j=0;j<value->clusters[i].a.number;++j) {
      printf("%d ",value->clusters[i].a.member[j]);
    }
    printf("\n");
    printf("%d\n",value->clusters[i].b.number);
    for(j=0;j<value->clusters[i].b.number;++j) {
      printf("%d ",value->clusters[i].b.member[j]);
    }
    printf("\n");
  }
}
  
void freevalue(struct gjnoc *value, int n)
{
  int i;
  for(i=0;i<(n-1);++i){
	GJfree(value->clusters[i].a.member);
	GJfree(value->clusters[i].b.member);
  }
  GJfree(value->clusters);
  GJfree(value->order);
  GJfree(value);
}
