/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import compbio.conservation.AminoAcidMatrix;
import compbio.conservation.ConservationAccessory;
import compbio.conservation.ConservationMatrices;
import compbio.data.sequence.ConservationMethod;
import compbio.data.sequence.SMERFSConstraints;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class Correlation {
    private final AminoAcidMatrix alignment;
    private final int winWidth;
    private final double gapTreshold;
    private double[] coeffs;
    private int[] global;
    private final int numofSequences;
    private final ExecutorService executor;

    public Correlation(AminoAcidMatrix alignment, int winWidth, double gapTreshold, ExecutorService exeService) {
        if (alignment == null) {
            throw new IllegalArgumentException("Alignment must not be null.");
        }
        if (winWidth < 0 || winWidth % 2 != 1 || winWidth > alignment.numberOfColumns()) {
            throw new IllegalArgumentException("ColWidth smaller than zero or an even number or largrt tah the number of columns");
        }
        if (winWidth > alignment.numberOfColumns()) {
            throw new IllegalArgumentException("The width of the window is greater than the length of the alignment.");
        }
        this.alignment = alignment;
        this.winWidth = winWidth;
        this.gapTreshold = gapTreshold;
        this.numofSequences = alignment.numberOfRows();
        this.executor = exeService;
    }

    private static int sequenceSimilartyBlosum(char[] seq1, char[] seq2) {
        assert (seq1.length == seq2.length);
        int similarity = 0;
        for (int i = 0; i < seq1.length; ++i) {
            similarity = (int)((double)similarity + ConservationMatrices.BlosumPair(seq1[i], seq2[i]));
        }
        return similarity;
    }

    private void globalSimilarity() throws InterruptedException, ExecutionException {
        this.global = new int[this.numofSequences * (this.numofSequences - 1) / 2];
        int index = 0;
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(this.numofSequences);
        for (int i = 0; i < this.numofSequences; ++i) {
            tasks.add(Executors.callable(new GlobalSimilarityWrapper(i, index)));
            index += this.numofSequences - i - 1;
        }
        this.executor.invokeAll(tasks);
    }

    private static double pearson(int[] arr1, int[] arr2) {
        assert (arr1.length == arr2.length);
        int arr1Sum = 0;
        int arr2Sum = 0;
        for (int i = 0; i < arr1.length; ++i) {
            arr1Sum += arr1[i];
            arr2Sum += arr2[i];
        }
        double arr1Ave = (double)arr1Sum / (double)arr1.length;
        double arr2Ave = (double)arr2Sum / (double)arr2.length;
        double sumProduct = 0.0;
        double a1Sum = 0.0;
        double a2Sum = 0.0;
        for (int i = 0; i < arr1.length; ++i) {
            double s1 = (double)arr1[i] - arr1Ave;
            double s2 = (double)arr2[i] - arr2Ave;
            sumProduct += s1 * s2;
            a1Sum += s1 * s1;
            a2Sum += s2 * s2;
        }
        if (a1Sum == 0.0 || a2Sum == 0.0) {
            return 0.0;
        }
        assert (Math.sqrt(a1Sum) * Math.sqrt(a2Sum) != 0.0);
        double result = sumProduct / (Math.sqrt(a1Sum) * Math.sqrt(a2Sum));
        return result;
    }

    private final int[][] localSimilarity2(int nrOfWindows, int begin, int end) {
        int[][] localSim = new int[nrOfWindows][this.numofSequences * (this.numofSequences - 1) / 2];
        int sum = 0;
        int globalIndex = 0;
        int windowNr = 0;
        for (int i = 0; i < this.numofSequences; ++i) {
            char[] rowI = this.alignment.getRow(i);
            for (int j = i + 1; j < this.numofSequences; ++j) {
                char[] rowJ = this.alignment.getRow(j);
                windowNr = 0;
                sum = 0;
                for (int z = begin; z < begin + this.winWidth; ++z) {
                    int index = 24 * ConservationMatrices.getIndex(rowI[z]) + ConservationMatrices.getIndex(rowJ[z]);
                    sum += ConservationMatrices.blosum2[index];
                }
                localSim[windowNr][globalIndex] = sum;
                ++windowNr;
                for (int k = begin + this.winWidth; k <= end; ++k) {
                    int index1 = 24 * ConservationMatrices.getIndex(rowI[k]) + ConservationMatrices.getIndex(rowJ[k]);
                    int index2 = 24 * ConservationMatrices.getIndex(rowI[k - this.winWidth]) + ConservationMatrices.getIndex(rowJ[k - this.winWidth]);
                    localSim[windowNr][globalIndex] = sum = sum - ConservationMatrices.blosum2[index2] + ConservationMatrices.blosum2[index1];
                    ++windowNr;
                }
                ++globalIndex;
            }
        }
        return localSim;
    }

    private double[] calcPearson() throws InterruptedException, ExecutionException {
        int nrOfWindows = (this.alignment.numberOfColumns() - this.alignment.numberOfColumns() % this.winWidth) / this.winWidth + ((this.alignment.numberOfColumns() - this.alignment.numberOfColumns() % this.winWidth) / this.winWidth - 1) * (this.winWidth - 1) + this.alignment.numberOfColumns() % this.winWidth;
        this.coeffs = new double[nrOfWindows];
        int coeffsIdx = 0;
        int WIN_SIZE = 50;
        int tail = nrOfWindows % 50;
        int turns = (nrOfWindows - tail) / 50;
        int start = 0;
        int end = this.winWidth - 1 + 50 - 1;
        this.globalSimilarity();
        ArrayList<Callable<Object>> locSimTasks = new ArrayList<Callable<Object>>();
        for (int i = 0; i < turns; ++i) {
            locSimTasks.add(Executors.callable(new LocalSimilarityWrapper(50, start, end, coeffsIdx)));
            coeffsIdx += 50;
            start = end - (this.winWidth - 1) + 1;
            end = start + (this.winWidth - 1) + 50 - 1;
        }
        if (tail != 0) {
            locSimTasks.add(Executors.callable(new LocalSimilarityWrapper(tail, start, this.alignment.numberOfColumns() - 1, coeffsIdx)));
        }
        this.executor.invokeAll(locSimTasks);
        return this.coeffs;
    }

    private void calcLocalSimilarity(int chunkSize, int start, int end, int coeffsIdx) {
        int[][] result = this.localSimilarity2(chunkSize, start, end);
        for (int a = 0; a < result.length; ++a) {
            this.coeffs[coeffsIdx] = Correlation.pearson(result[a], this.global);
            ++coeffsIdx;
        }
    }

    double[] getCorrelationScore(SMERFSConstraints score, boolean normalize) throws InterruptedException, ExecutionException {
        double[] results = null;
        results = this.calcPearson();
        double[] columnResults = score == SMERFSConstraints.MAX_SCORE ? this.giveMaxToColumn(results) : this.giveMidToColumn(results);
        this.rejectOverTreshold(columnResults);
        double[] normalized = null;
        if (normalize) {
            normalized = ConservationAccessory.normalize01(columnResults, ConservationMethod.SMERFS);
        }
        if (normalized == null) {
            return columnResults;
        }
        return normalized;
    }

    private double findMax(double[] scores, int begin, int end) {
        if (end < begin) {
            throw new IllegalArgumentException("End is smaller than the begin.");
        }
        if (begin == end) {
            return scores[begin];
        }
        double max = scores[begin];
        for (int i = begin; i < end + 1; ++i) {
            if (!(scores[i] > max)) continue;
            max = scores[i];
        }
        return max;
    }

    private double[] giveMaxToColumn(double[] windowScores) {
        int i;
        double[] scores = new double[this.alignment.numberOfColumns()];
        for (i = 0; i < this.winWidth - 1; ++i) {
            scores[i] = this.findMax(windowScores, 0, i);
        }
        for (i = this.winWidth - 1; i < scores.length - (this.winWidth - 1); ++i) {
            scores[i] = this.findMax(windowScores, i - (this.winWidth - 1), i);
        }
        int begin = windowScores.length - 1 - (this.winWidth - 2);
        int end = windowScores.length - 1;
        for (int i2 = scores.length - (this.winWidth - 1); i2 < scores.length; ++i2) {
            scores[i2] = this.findMax(windowScores, begin, end);
            ++begin;
        }
        return scores;
    }

    private double[] giveMidToColumn(double[] windowScores) {
        int i;
        double[] columnResults = new double[this.alignment.numberOfColumns()];
        int ends = (this.winWidth - 1) / 2;
        for (i = 0; i < ends; ++i) {
            columnResults[i] = windowScores[0];
            columnResults[columnResults.length - 1 - i] = windowScores[windowScores.length - 1];
        }
        for (i = 0; i < windowScores.length; ++i) {
            columnResults[i + ends] = windowScores[i];
        }
        return columnResults;
    }

    private void rejectOverTreshold(double[] results) {
        for (int i = 0; i < this.alignment.numberOfColumns(); ++i) {
            Map<Character, Integer> colMap = this.alignment.getTotalAcidsFreqByCol().get(i);
            if (!colMap.containsKey(Character.valueOf('-')) || !((double)(colMap.get(Character.valueOf('-')) / this.numofSequences) > this.gapTreshold)) continue;
            results[i] = 0.0;
        }
    }

    private class LocalSimilarityWrapper
    implements Runnable {
        final int chunkSize;
        final int start;
        final int end;
        final int coeffsIdx;

        public LocalSimilarityWrapper(int chunkSize, int start, int end, int coeffsIdx) {
            this.chunkSize = chunkSize;
            this.start = start;
            this.end = end;
            this.coeffsIdx = coeffsIdx;
        }

        public void run() {
            Correlation.this.calcLocalSimilarity(this.chunkSize, this.start, this.end, this.coeffsIdx);
        }
    }

    private class GlobalSimilarityWrapper
    implements Runnable {
        final int i;
        final int startIndex;
        final char[] alrow;

        public GlobalSimilarityWrapper(int i, int startIndex) {
            this.i = i;
            this.startIndex = startIndex;
            this.alrow = Correlation.this.alignment.getRow(i);
        }

        public void run() {
            int index = this.startIndex;
            for (int j = this.i + 1; j < Correlation.this.numofSequences; ++j) {
                ((Correlation)Correlation.this).global[index] = Correlation.sequenceSimilartyBlosum(this.alrow, Correlation.this.alignment.getRow(j));
                ++index;
            }
        }
    }
}

