/*
 * Decompiled with CFR 0.152.
 */
package compbio.conservation;

import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ShannonEnthropy {
    ShannonEnthropy() {
    }

    static double ShannonLog2(Map<Character, Integer> map, double nrSequences) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        assert (!map.isEmpty()) : "Shannon has been fed an empty map";
        assert (nrSequences > 0.0);
        double sum = 0.0;
        Set<Character> keys = map.keySet();
        for (Character key : keys) {
            if (key.charValue() == '-') continue;
            double value = (double)map.get(key).intValue() / nrSequences;
            sum += value * (Math.log(value) / Math.log(2.0));
        }
        return -sum;
    }

    static double ShannonLn(Map<Character, Integer> map, int nrSequences) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        assert (!map.isEmpty()) : "Shannon has been fed an empty map";
        assert (nrSequences > 0);
        double sum = 0.0;
        Set<Character> keys = map.keySet();
        for (Character key : keys) {
            if (key.charValue() == '-') continue;
            double value = (double)map.get(key).intValue() / (double)nrSequences;
            sum += value * Math.log(value);
        }
        return -sum;
    }
}

